/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.tools;

import java.util.Map;
import java.util.Objects;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.UnknownT;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.cel.tools.ScriptExecutionException;

public final class Script {
    private final Env env;
    private final Program prg;

    Script(Env env, Program prg) {
        this.env = env;
        this.prg = prg;
    }

    public <T> T execute(Class<T> resultType, Map<String, Object> arguments) throws ScriptException {
        Objects.requireNonNull(resultType, "resultType missing");
        Objects.requireNonNull(arguments, "arguments missing");
        Program.EvalResult evalResult = this.prg.eval(arguments);
        Val result = evalResult.getVal();
        if (Err.isError((Val)result)) {
            Err err = (Err)result;
            throw new ScriptExecutionException(err.toString(), err.getCause());
        }
        if (UnknownT.isUnknown((Object)result)) {
            if (resultType == Val.class || resultType == Object.class) {
                return (T)result;
            }
            throw new ScriptExecutionException(String.format("script returned unknown %s, but expected result type is %s", result, resultType.getName()));
        }
        return (T)result.convertToNative(resultType);
    }
}

