/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.Space;

public class ClassDeclarationToString {
    private static final JavaPrinter<Void> CLASS_DECL_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(classDecl.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinter();
            if (!classDecl.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            switch (classDecl.getKind()) {
                case Class: {
                    acc.append("class ");
                    break;
                }
                case Enum: {
                    acc.append("enum ");
                    break;
                }
                case Interface: {
                    acc.append("interface ");
                    break;
                }
                case Annotation: {
                    acc.append("@interface ");
                }
            }
            acc.append(classDecl.getName().printTrimmed());
            if (classDecl.getTypeParameters() != null) {
                this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", unused);
                acc.append(' ');
            }
            this.visitLeftPadded("extends", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, unused);
            if (classDecl.getImplements() != null) {
                if (J.ClassDeclaration.Kind.Type.Interface.equals((Object)classDecl.getKind())) {
                    acc.append("extends");
                } else {
                    acc.append("implements");
                }
            }
            this.visitContainer("", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", "", unused);
            return classDecl;
        }
    };

    public static String toString(J.ClassDeclaration clazz) {
        return CLASS_DECL_PRINTER.print(clazz, null);
    }
}

