/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class NoFinalizer
extends Recipe {
    public String getDisplayName() {
        return "Remove `finalize()` method";
    }

    public String getDescription() {
        return "Finalizers are deprecated. Use of `finalize()` can lead to performance issues, deadlocks, hangs, and other undesirable behavior.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NoFinalizerVisitor();
    }

    private static class NoFinalizerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher FINALIZER = new MethodMatcher("java.lang.Object finalize()");

        private NoFinalizerVisitor() {
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J cd = super.visitClassDeclaration(classDecl, ctx);
            cd = ((J.ClassDeclaration)cd).withBody(((J.ClassDeclaration)cd).getBody().withStatements(ListUtils.map(((J.ClassDeclaration)cd).getBody().getStatements(), stmt -> {
                if (stmt instanceof J.MethodDeclaration && FINALIZER.matches((J.MethodDeclaration)stmt, classDecl)) {
                    return null;
                }
                return stmt;
            })));
            return cd;
        }
    }
}

