/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.Collections;
import java.util.List;
import org.mockito.MockedConstruction;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.util.StringUtil;
import org.mockito.invocation.Location;
import org.mockito.plugins.MockMaker;

public final class MockedConstructionImpl<T>
implements MockedConstruction<T> {
    private final MockMaker.ConstructionMockControl<T> control;
    private boolean closed;
    private final Location location = new LocationImpl();

    protected MockedConstructionImpl(MockMaker.ConstructionMockControl<T> control) {
        this.control = control;
    }

    @Override
    public List<T> constructed() {
        return Collections.unmodifiableList(this.control.getMocks());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.assertNotClosed();
        this.closed = true;
        this.control.disable();
    }

    @Override
    public void closeOnDemand() {
        if (!this.closed) {
            this.close();
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new MockitoException(StringUtil.join("The static mock created at", this.location.toString(), "is already resolved and cannot longer be used"));
        }
    }
}

