/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.jfrog.build.api.Dependency;

public class DependencyBuilder {
    private String id;
    private String type;
    private Set<String> scopes;
    private String sha1;
    private String sha256;
    private String md5;
    private String remotePath;
    private String[][] requestedBy;
    private Properties properties;

    public Dependency build() {
        Dependency dependency = new Dependency();
        dependency.setId(this.id);
        dependency.setType(this.type);
        dependency.setScopes(this.scopes);
        dependency.setSha1(this.sha1);
        dependency.setSha256(this.sha256);
        dependency.setMd5(this.md5);
        dependency.setRemotePath(this.remotePath);
        dependency.setRequestedBy(this.requestedBy);
        dependency.setProperties(this.properties);
        return dependency;
    }

    public DependencyBuilder id(String id) {
        this.id = id;
        return this;
    }

    public DependencyBuilder type(String type) {
        this.type = type;
        return this;
    }

    public DependencyBuilder scopes(Set<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public DependencyBuilder addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    public DependencyBuilder sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    public DependencyBuilder sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    public DependencyBuilder md5(String md5) {
        this.md5 = md5;
        return this;
    }

    public DependencyBuilder remotePath(String remotePath) {
        this.remotePath = remotePath;
        return this;
    }

    public DependencyBuilder requestedBy(String[][] requestedBy) {
        this.requestedBy = requestedBy;
        return this;
    }

    public DependencyBuilder addRequestedBy(String[] pathToModuleRoot) {
        this.requestedBy = (String[][])ArrayUtils.add((Object[])this.requestedBy, (Object)pathToModuleRoot);
        return this;
    }

    public DependencyBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public DependencyBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }

    public DependencyBuilder addProperties(Properties properties) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }
}

