/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.SystemUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.CleanUpBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0011\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0086\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "", "pluginClassLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "callVoidStaticMethod", "", "classFqName", "", "methodName", "cleanJarCache", "invoke", "gradleVersion", "stopZipFileCache", "kotlin-gradle-plugin"})
public final class CompilerServicesCleanup {
    private final Logger log;
    private ClassLoader pluginClassLoader;

    public final Logger getLog() {
        return this.log;
    }

    public final void invoke(@NotNull String gradleVersion) {
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        boolean bl = this.pluginClassLoader != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinPluginWrapperKt.kotlinDebug(this.log, "compiler services cleanup");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.cleanJarCache();
        }
        String string = CleanUpBuildListenerKt.access$comparableVersionStr(gradleVersion);
        if (string != null) {
            String string2 = string;
            String it = string2;
            KotlinPluginWrapperKt.kotlinDebug(this.log, "detected gradle version " + it);
            String string3 = CleanUpBuildListenerKt.access$comparableVersionStr("2.4");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            if (it.compareTo(string3) < 0) {
                this.stopZipFileCache();
            }
        }
        this.pluginClassLoader = null;
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("org.jetbrains.kotlin.com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void callVoidStaticMethod(String classFqName, String methodName) {
        String string = classFqName;
        int n = StringsKt.lastIndexOf$default((CharSequence)classFqName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String shortName = string3;
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + shortName + " class");
        ClassLoader classLoader = this.pluginClassLoader;
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        Class<?> cls = classLoader.loadClass(classFqName);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + methodName + "() method");
        Method method = cls.getMethod(methodName, new Class[0]);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Call " + shortName + "." + methodName + "()");
        method.invoke(null, new Object[0]);
    }

    private final void cleanJarCache() {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Clean JAR cache");
        this.callVoidStaticMethod("org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler", "clearFileAccessorCache");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "JAR cache cleared");
    }

    public CompilerServicesCleanup(@Nullable ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(this.getClass());
    }
}

