/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectoryContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryImpl;

public class PsiDirectoryFactoryImpl
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiDirectoryFactoryImpl(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiDirectory createDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "createDirectory"));
        }
        PsiDirectoryImpl psiDirectoryImpl = new PsiDirectoryImpl(this.myManager, file2);
        if (psiDirectoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "createDirectory"));
        }
        return psiDirectoryImpl;
    }

    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "getQualifiedName"));
        }
        if (presentable) {
            String string = FileUtil.getLocationRelativeToUserHome(directory.getVirtualFile().getPresentableUrl());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "getQualifiedName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "getQualifiedName"));
        }
        return "";
    }

    @Override
    public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "getDirectoryContainer"));
        }
        return null;
    }

    @Override
    public boolean isPackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryFactoryImpl", "isPackage"));
        }
        return false;
    }

    @Override
    public boolean isValidPackageName(String name) {
        return true;
    }
}

