/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.HashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;

public class HashSetUtil {
    @NotNull
    public static <T> Set<T> linkedHashSet(@NotNull Collection<T> set, @NotNull EqualityPolicy<T> policy) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        LinkedHashMap<T, String> map2 = new LinkedHashMap<T, String>(policy);
        for (T t : set) {
            map2.put(t, "");
        }
        Set set2 = map2.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        return set2;
    }

    @NotNull
    public static <T> Set<T> symmetricDifference(@NotNull Set<T> set1, @NotNull Set<T> set2) {
        if (set1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set1", "org/jetbrains/kotlin/utils/HashSetUtil", "symmetricDifference"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set2", "org/jetbrains/kotlin/utils/HashSetUtil", "symmetricDifference"));
        }
        HashSet<T> intersection = new HashSet<T>();
        intersection.addAll(set1);
        intersection.retainAll(set2);
        HashSet<T> result2 = new HashSet<T>();
        result2.addAll(set1);
        result2.addAll(set2);
        result2.removeAll(intersection);
        HashSet<T> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/HashSetUtil", "symmetricDifference"));
        }
        return hashSet;
    }
}

