/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/validation/OperatorValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "checkDeprecatedUnaryConventions", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "validateCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Companion", "kotlin-compiler"})
public final class OperatorValidator
implements SymbolUsageValidator {
    public static final Companion Companion = new Companion(null);

    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        CallableDescriptor callableDescriptor = targetDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorValidator.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        PsiElement psiElement = element;
        if (!(psiElement instanceof KtElement)) {
            psiElement = null;
        }
        KtElement ktElement = (KtElement)psiElement;
        if (ktElement == null) {
            return;
        }
        KtElement jetElement = ktElement;
        ResolvedCall<?> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getCall()) == null) {
            resolvedCall3 = (Call)trace.getBindingContext().get(BindingContext.CALL, jetElement);
        }
        ResolvedCall<?> call = resolvedCall3;
        Function0<Boolean> isInvokeCall$ = new Function0<Boolean>((Call)((Object)call)){
            final /* synthetic */ Call $call;

            public final boolean invoke() {
                return this.$call instanceof CallTransformer.CallForImplicitInvoke;
            }
            {
                this.$call = call;
                super(0);
            }
        };
        Function0<Boolean> isMultiDeclaration$ = new Function0<Boolean>(resolvedCall2, (Call)((Object)call)){
            final /* synthetic */ ResolvedCall $resolvedCall;
            final /* synthetic */ Call $call;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                if (this.$resolvedCall == null) return false;
                Call call = this.$call;
                if (!((call != null ? call.getCallElement() : null) instanceof KtDestructuringDeclarationEntry)) return false;
                return true;
            }
            {
                this.$resolvedCall = resolvedCall2;
                this.$call = call;
                super(0);
            }
        };
        Function0<Boolean> isConventionOperator$ = new Function0<Boolean>(jetElement){
            final /* synthetic */ KtElement $jetElement;

            public final boolean invoke() {
                if (!(this.$jetElement instanceof KtOperationReferenceExpression)) {
                    return false;
                }
                return KtOperationReferenceExpression.getNameForConventionalOperation$default((KtOperationReferenceExpression)this.$jetElement, false, false, 3, null) != null;
            }
            {
                this.$jetElement = ktElement;
                super(0);
            }
        };
        Function0<Boolean> isArrayAccessExpression$ = new Function0<Boolean>(jetElement){
            final /* synthetic */ KtElement $jetElement;

            public final boolean invoke() {
                return this.$jetElement instanceof KtArrayAccessExpression;
            }
            {
                this.$jetElement = ktElement;
                super(0);
            }
        };
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)((Object)call)).itIsVariableAsFunctionCall) {
            Call outerCall;
            Call call2 = outerCall = ((CallTransformer.CallForImplicitInvoke)((Object)call)).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "outerCall");
            if (CallResolverUtilKt.isConventionCall(call2)) {
                throw (Throwable)((Object)new AssertionError((Object)("Illegal resolved call to variable with invoke for " + outerCall + ". Variable: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor())));
            }
        }
        if (isMultiDeclaration$.invoke() || isInvokeCall$.invoke()) {
            if (!functionDescriptor2.isOperator() && call != null) {
                PsiElement psiElement2 = call.getCallElement();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "call.callElement");
                Companion.report(psiElement2, functionDescriptor2, trace);
            }
            return;
        }
        boolean isConventionOperator = isConventionOperator$.invoke();
        if (isConventionOperator || isArrayAccessExpression$.invoke()) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(jetElement, functionDescriptor2, trace);
            }
            if (isConventionOperator && call != null) {
                this.checkDeprecatedUnaryConventions((Call)((Object)call), functionDescriptor2, trace);
            }
        }
    }

    private final void checkDeprecatedUnaryConventions(Call call, FunctionDescriptor functionDescriptor, DiagnosticSink sink) {
        block2: {
            KtElement ktElement = call.getCallElement();
            if (!(ktElement instanceof KtPrefixExpression)) {
                ktElement = null;
            }
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)ktElement;
            if (ktPrefixExpression == null) break block2;
            KtPrefixExpression ktPrefixExpression2 = ktPrefixExpression;
            KtPrefixExpression expr = ktPrefixExpression2;
            Name functionName = functionDescriptor.getName();
            if (Intrinsics.areEqual(functionName, OperatorNameConventions.PLUS) || Intrinsics.areEqual(functionName, OperatorNameConventions.MINUS)) {
                Name newName2 = Intrinsics.areEqual(functionName, OperatorNameConventions.PLUS) ? OperatorNameConventions.UNARY_PLUS : OperatorNameConventions.UNARY_MINUS;
                sink.report(Errors.DEPRECATED_UNARY_PLUS_MINUS.on((KtUnaryExpression)((PsiElement)expr), functionDescriptor, newName2.asString()));
            }
        }
    }

    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        SymbolUsageValidator.DefaultImpls.validateTypeUsage(this, targetDescriptor, trace, element);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/validation/OperatorValidator$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "report", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "kotlin-compiler"})
    public static final class Companion {
        public final void report(@NotNull PsiElement element, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(sink, "sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(element, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

