/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0011\u0010\n\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u000b*\u00020\f\u001a\u0011\u0010\r\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u000b*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\f\u001a\n\u0010\u0012\u001a\u00020\u000f*\u00020\f\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0010\u001a \u0010\u0014\u001a\u00020\u000f*\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002\u001a\n\u0010\u0018\u001a\u00020\u000f*\u00020\u0015\u001a\n\u0010\u0019\u001a\u00020\u000f*\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_STATIC_ANNOTATION_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "argumentValue", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "findJvmSyntheticAnnotation", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findStrictfpAnnotation", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "hasJvmStaticAnnotation", "hasJvmSyntheticAnnotation", "isInlineOnlyOrReified", "isPlatformStaticIn", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "predicate", "Lkotlin/Function1;", "isPlatformStaticInCompanionObject", "isPlatformStaticInObjectOrClass", "kotlin-compiler"})
public final class AnnotationUtilKt {
    private static final FqName JVM_STATIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");
    private static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    private static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    public static final boolean hasJvmStaticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getAnnotations().findAnnotation(JVM_STATIC_ANNOTATION_FQ_NAME) != null;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.findJvmSyntheticAnnotation($receiver) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), STRICTFP_ANNOTATION_FQ_NAME);
    }

    public static final boolean isPlatformStaticInObjectOrClass(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInObjectOrClass.1.INSTANCE);
    }

    public static final boolean isPlatformStaticInCompanionObject(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInCompanionObject.1.INSTANCE);
    }

    private static final boolean isPlatformStaticIn(@NotNull CallableDescriptor $receiver, Function1<? super DeclarationDescriptor, Boolean> predicate) {
        boolean bl;
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "propertyDescriptor.containingDeclaration");
            bl = predicate.invoke(declarationDescriptor).booleanValue() && (AnnotationUtilKt.hasJvmStaticAnnotation($receiver) || AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor));
        } else {
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
            bl = predicate.invoke(declarationDescriptor) != false && AnnotationUtilKt.hasJvmStaticAnnotation($receiver);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object argumentValue(@NotNull AnnotationDescriptor $receiver, @NotNull String parameterName) {
        ConstantValue constant;
        Object object;
        block3: {
            void var3_3;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
            Iterable $receiver$iv = $receiver.getAllValueArguments().entrySet();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual(((ValueParameterDescriptor)it.getKey()).getName().asString(), parameterName)) continue;
                if (found$iv) {
                    object = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        Map.Entry entry = (Map.Entry)object;
        ConstantValue constantValue = constant = entry != null ? (ConstantValue)entry.getValue() : null;
        if (constant == null || constant instanceof ErrorValue) {
            return null;
        }
        return constant.getValue();
    }

    public static final boolean isInlineOnlyOrReified(@NotNull MemberDescriptor $receiver) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            if (!($receiver instanceof FunctionDescriptor)) {
                return false;
            }
            Iterable $receiver$iv = ((FunctionDescriptor)$receiver).getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (!it.isReified()) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl || AnnotationUtilKt.hasInlineOnlyAnnotation($receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasInlineOnlyAnnotation(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!($receiver instanceof FunctionDescriptor)) {
            return false;
        }
        if (!((FunctionDescriptor)$receiver).getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME)) return false;
        boolean bl = InlineUtil.isInline($receiver);
        boolean $receiver2 = bl;
        if (_Assertions.ENABLED && !$receiver2) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!bl) return false;
        return true;
    }
}

