/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulators;
import org.jetbrains.kotlin.com.intellij.psi.LiteralTextEscaper;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KotlinStringLiteralTextEscaper;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtStringTemplateExpression
extends KtExpressionImpl
implements PsiLanguageInjectionHost {
    private static final TokenSet TOKENS_SUITABLE_FOR_INJECTION = TokenSet.create(KtNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY, KtNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);

    public KtStringTemplateExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "accept"));
        }
        return visitor2.visitStringTemplateExpression(this, data);
    }

    @NotNull
    public KtStringTemplateEntry[] getEntries() {
        KtStringTemplateEntry[] ktStringTemplateEntryArray = this.findChildrenByClass(KtStringTemplateEntry.class);
        if (ktStringTemplateEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "getEntries"));
        }
        return ktStringTemplateEntryArray;
    }

    @Override
    public boolean isValidHost() {
        ASTNode node = this.getNode();
        for (ASTNode child = node.getFirstChildNode().getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == KtTokens.CLOSING_QUOTE) {
                return true;
            }
            if (TOKENS_SUITABLE_FOR_INJECTION.contains(child.getElementType())) continue;
            return false;
        }
        return false;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "updateText"));
        }
        KtExpression newExpression = new KtPsiFactory(this.getProject()).createExpressionIfPossible(text);
        if (newExpression instanceof KtStringTemplateExpression) {
            return (KtStringTemplateExpression)this.replace(newExpression);
        }
        return ElementManipulators.handleContentChange(this, text);
    }

    @Override
    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        KotlinStringLiteralTextEscaper kotlinStringLiteralTextEscaper = new KotlinStringLiteralTextEscaper(this);
        if (kotlinStringLiteralTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "createLiteralTextEscaper"));
        }
        return kotlinStringLiteralTextEscaper;
    }
}

