/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\f\u0010\u001e\u001a\u00020\u000b*\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "scope", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsScope;", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lcom/google/dart/compiler/backend/js/ast/JsScope;)V", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "capturedDescriptors", "", "getCapturedDescriptors", "()Ljava/util/Set;", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "captureIfNeed", "", "descriptor", "isInLocalDeclaration", "", "isReceiverAncestor", "isSingletonReceiver", "used", "getJsNameForCapturedDescriptor", "kotlin-compiler"})
public final class UsageTracker {
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    private final UsageTracker parent;
    @NotNull
    private final MemberDescriptor containingDescriptor;
    private final JsScope scope;

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    @NotNull
    public final Set<DeclarationDescriptor> getCapturedDescriptors() {
        Set<DeclarationDescriptor> set = this.captured.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "captured.keys");
        return set;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor2)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL)) {
            boolean bl = !descriptor2.getName().isSpecial();
            if (_Assertions.ENABLED && !bl) {
                String string = "Function with special name can not be captured, descriptor: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor2).isReified()) {
            this.captureIfNeed(descriptor2);
        }
    }

    private final void captureIfNeed(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null || UsageTrackerKt.isCaptured(this, descriptor2) || !this.isInLocalDeclaration() || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor2, true) || this.isReceiverAncestor(descriptor2) || this.isSingletonReceiver(descriptor2)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor2);
        }
        Map map2 = this.captured;
        JsName jsName = this.getJsNameForCapturedDescriptor(descriptor2);
        map2.put(descriptor2, jsName);
    }

    private final boolean isInLocalDeclaration() {
        MemberDescriptor memberDescriptor;
        MemberDescriptor container = this.containingDescriptor;
        if (container instanceof ConstructorDescriptor) {
            MemberDescriptor memberDescriptor2 = ((ConstructorDescriptor)container).getContainingDeclaration();
            memberDescriptor = memberDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(memberDescriptor2, "container.containingDeclaration");
        } else {
            memberDescriptor = container;
        }
        return DescriptorUtils.isDescriptorWithLocalVisibility(memberDescriptor);
    }

    private final boolean isReceiverAncestor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        if (!(this.containingDescriptor instanceof ClassDescriptor) && !(this.containingDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor currentClass = classDescriptor2;
        Iterator<ClassDescriptor> iterator2 = SequencesKt.generateSequence(containingClass, (Function1)isReceiverAncestor.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor outerDeclaration = iterator2.next();
            if (!DescriptorUtils.isSubclass(outerDeclaration, currentClass)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSingletonReceiver(DeclarationDescriptor descriptor2) {
        ClassDescriptor containingClass;
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        DeclarationDescriptor container = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        if (!DescriptorUtils.isObject(container)) {
            return false;
        }
        return this.containingDescriptor instanceof ClassDescriptor || !Intrinsics.areEqual(containingClass = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false), container);
    }

    private final JsName getJsNameForCapturedDescriptor(@NotNull DeclarationDescriptor $receiver) {
        String string;
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ReceiverParameterDescriptor) {
            string = UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$receiver);
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            String string2 = Namer.isInstanceSuggestedName((TypeParameterDescriptor)$receiver);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "Namer.isInstanceSuggestedName(this)");
        } else {
            string = "closure" + "$" + ManglingUtils.getSuggestedName($receiver);
        }
        String suggestedName = string;
        JsName jsName = this.scope.declareFreshName(suggestedName);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareFreshName(suggestedName)");
        return jsName;
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull JsScope scope) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.scope = scope;
        this.captured = MapsKt.linkedMapOf(new Pair[0]);
    }
}

