/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AbstractCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;

class CollectionBinding
extends AbstractCollectionBinding {
    public CollectionBinding(@NotNull ParameterizedType type2, @Nullable MutableAccessor accessor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/xmlb/CollectionBinding", "<init>"));
        }
        super(XmlSerializerImpl.typeToClass(type2.getActualTypeArguments()[0]), accessor);
    }

    @Override
    Object processResult(Collection result2, Object target) {
        if (this.myAccessor == null) {
            return result2;
        }
        assert (target != null) : "Null target in " + this.myAccessor;
        assert (target instanceof Collection) : "Wrong target: " + target.getClass() + " in " + this.myAccessor;
        Collection c = (Collection)target;
        c.clear();
        c.addAll(result2);
        return target;
    }

    @Override
    protected String getCollectionTagName(@Nullable Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return "collection";
    }

    @Override
    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "org/jetbrains/kotlin/com/intellij/util/xmlb/CollectionBinding", "createCollection"));
        }
        return tagName.equals("set") ? new HashSet() : super.createCollection(tagName);
    }
}

