/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentBTreeEnumerator;

public class ResizeableMappedFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ResizeableMappedFile");
    private long myLogicalSize;
    private final PagedFileStorage myStorage;

    public ResizeableMappedFile(@NotNull File file, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/io/ResizeableMappedFile", "<init>"));
        }
        this(file, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResizeableMappedFile(@NotNull File file, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/io/ResizeableMappedFile", "<init>"));
        }
        this.myStorage = new PagedFileStorage(file, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        boolean exists = file.exists();
        if (!exists || file.length() == 0L) {
            if (!exists) {
                FileUtil.createParentDirs(file);
            }
            this.writeLength(0L);
        }
        this.myLogicalSize = this.readLength();
        if (this.myLogicalSize == 0L) {
            try {
                this.getPagedFileStorage().lock();
                this.myStorage.resize(initialSize);
            }
            finally {
                this.getPagedFileStorage().unlock();
            }
        }
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    private void resize(long size) {
        try {
            this.myStorage.resize(size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    private void expand(long max) {
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        long suggestedSize = Math.max(realSize + 1L, 2L);
        while (max > suggestedSize) {
            long newSuggestedSize = suggestedSize * 13L >> 3;
            if (newSuggestedSize >= Integer.MAX_VALUE) {
                suggestedSize += suggestedSize / 5L;
                continue;
            }
            suggestedSize = newSuggestedSize;
        }
        int roundFactor = PersistentBTreeEnumerator.PAGE_SIZE;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        this.resize(suggestedSize);
    }

    private File getLengthFile() {
        return new File(this.myStorage.getFile().getPath() + ".len");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(long len) {
        final File lengthFile = this.getLengthFile();
        FilterOutputStream stream2 = null;
        try {
            stream2 = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

                @Override
                @Nullable
                public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                    try {
                        return new DataOutputStream(new FileOutputStream(lengthFile));
                    }
                    catch (FileNotFoundException ex) {
                        if (!lastAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
            if (stream2 != null) {
                ((java.io.DataOutputStream)stream2).writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    public void force() {
        if (this.isDirty()) {
            this.writeLength(this.myLogicalSize);
        }
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLength() {
        File lengthFile = this.getLengthFile();
        FilterInputStream stream2 = null;
        try {
            stream2 = new DataInputStream(new FileInputStream(lengthFile));
            long l = ((DataInputStream)stream2).readLong();
            return l;
        }
        catch (IOException e) {
            this.writeLength(this.realSize());
            long l = this.realSize();
            return l;
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public int getInt(long index2) {
        return this.myStorage.getInt(index2);
    }

    public void putInt(long index2, int value) {
        this.ensureSize(index2 + 4L);
        this.myStorage.putInt(index2, value);
    }

    public long getLong(long index2) {
        return this.myStorage.getLong(index2);
    }

    public void putLong(long index2, long value) {
        this.ensureSize(index2 + 8L);
        this.myStorage.putLong(index2, value);
    }

    public byte get(long index2) {
        return this.myStorage.get(index2);
    }

    public void get(long index2, byte[] dst, int offset2, int length) {
        this.myStorage.get(index2, dst, offset2, length);
    }

    public void put(long index2, byte[] src, int offset2, int length) {
        this.ensureSize(index2 + (long)length);
        this.myStorage.put(index2, src, offset2, length);
    }

    public void close() {
        try {
            this.force();
        }
        finally {
            this.myStorage.close();
        }
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/ResizeableMappedFile", "getPagedFileStorage"));
        }
        return pagedFileStorage;
    }
}

