/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private static final Object INIT = new String("#init");
    private static final Object STOP = new String("#stop");
    private static final Object SKIP = new String("#skip");
    private Object cur = INIT;
    private final Op firstOp = new Op<Object>(null);
    private Op lastOp = this.firstOp;
    private static final Condition<JBIterator<?>> ADVANCE = new Condition<JBIterator<?>>(){

        @Override
        public boolean value(JBIterator<?> it) {
            return it.advance();
        }
    };

    public static <E> JBIterator<E> from(final Iterator<E> it) {
        return it instanceof JBIterator ? (JBIterator<E>)it : new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    protected abstract E nextImpl();

    protected final E stop() {
        this.cur = STOP;
        return null;
    }

    private boolean isStopped() {
        return this.cur == STOP;
    }

    @Override
    public final boolean hasNext() {
        if (this.cur == INIT) {
            this.advanceImpl();
        }
        return this.cur != STOP;
    }

    @Override
    public final E next() {
        if (this.cur == INIT) {
            this.advanceImpl();
        }
        E result2 = this.current();
        this.cur = INIT;
        return result2;
    }

    public final boolean advance() {
        if (this.cur != STOP) {
            this.advanceImpl();
        }
        return this.cur != STOP;
    }

    public E current() {
        if (this.cur == STOP) {
            throw new NoSuchElementException();
        }
        return (E)this.cur;
    }

    private void advanceImpl() {
        this.cur = INIT;
        Object o = this.nextImpl();
        if (this.isStopped()) {
            return;
        }
        Op op = this.firstOp.nextOp;
        while (op != null) {
            o = op.apply(o);
            if (this.isStopped()) {
                return;
            }
            if (o == SKIP) {
                o = this.nextImpl();
                if (this.isStopped()) {
                    return;
                }
                op = this.firstOp;
            }
            op = op.nextOp;
        }
        this.cur = o;
    }

    @NotNull
    public final <T> JBIterator<T> transform(@NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "transform"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Function<? super E, T>>(function){

            @Override
            public Object apply(Object o) {
                return ((Function)this.impl).fun(o);
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "transform"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "filter"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){

            @Override
            public Object apply(Object o) {
                return ((Condition)this.impl).value(o) ? o : SKIP;
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "filter"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        JBIterator jBIterator = this.takeWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "take"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){

            @Override
            public Object apply(Object o) {
                return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
            }

            @Override
            public String toString() {
                return "takeWhile:" + super.toString();
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        JBIterator jBIterator = this.skipWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skip"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){
            boolean active;
            {
                super(impl);
                this.active = true;
            }

            @Override
            public Object apply(Object o) {
                if (this.active && condition.value(o)) {
                    return SKIP;
                }
                this.active = false;
                return o;
            }

            @Override
            public String toString() {
                return "skipWhile:" + super.toString();
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        return jBIterator;
    }

    @NotNull
    private <T> T addOp(@NotNull Op op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "addOp"));
        }
        this.lastOp = this.lastOp.nextOp = op;
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "addOp"));
        }
        return (T)jBIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        JBIterable<Op> ops = this.operationsImpl();
        return "{cur=" + this.cur + "; ops[" + ops.size() + "]=" + ops + "}";
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.firstOp.nextOp, new Function<Op, Op>(){

            @Override
            public Op fun(Op op) {
                return op.nextOp;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "operationsImpl"));
        }
        return jBIterable;
    }

    static String toShortString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "toShortString"));
        }
        String fqn = o.getClass().getName();
        return StringUtil.replace(o.toString(), fqn, StringUtil.getShortName(fqn, '.'));
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        public CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        public Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.impl == null ? "" : JBIterator.toShortString(this.impl);
        }
    }
}

