/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspectEvent;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLock;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiToDocumentSynchronizer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public abstract class DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");

    public abstract void commitSynchronously(@NotNull Document var1, @NotNull Project var2);

    public abstract void commitAsynchronously(@NotNull Project var1, @NotNull Document var2, @NonNls @NotNull Object var3, @NotNull ModalityState var4);

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(final @NotNull CommitTask task, final @NotNull PsiFile file, final boolean synchronously) {
        CharSequence chars;
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        Document document = task.document;
        final long startDocModificationTimeStamp = document.getModificationStamp();
        final FileElement myTreeElementBeingReparsedSoItWontBeCollected = ((PsiFileImpl)file).calcTreeElement();
        TextRange changedPsiRange = DocumentCommitProcessor.getChangedPsiRange(file, myTreeElementBeingReparsedSoItWontBeCollected, chars = document.getImmutableCharSequence());
        if (changedPsiRange == null) {
            return null;
        }
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        final DiffLog diffLog = blockSupport.reparseRange(file, changedPsiRange, chars, task.indicator, task.myLastCommittedText);
        return new Processor<Document>(){

            @Override
            public boolean process(Document document) {
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                DocumentCommitProcessor.this.log("Finishing", task, synchronously, document.getModificationStamp(), startDocModificationTimeStamp);
                if (document.getModificationStamp() != startDocModificationTimeStamp || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getCachedViewProvider(document) != file.getViewProvider()) {
                    return false;
                }
                DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                DocumentCommitProcessor.this.assertAfterCommit(document, file, myTreeElementBeingReparsedSoItWontBeCollected);
                return true;
            }
        };
    }

    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result2 = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result2;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result2;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text, boolean fromStart) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "getMatchingLength"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "getMatchingLength"));
        }
        int patternIndex = fromStart ? 0 : text.length() - 1;
        int finalPatternIndex = fromStart ? text.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result2 = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = DocumentCommitProcessor.getLeafMatchingLength(chars, text, patternIndex, finalPatternIndex, direction);
                result2 += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result2;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        int psiLength = treeElement.getTextLength();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = DocumentCommitProcessor.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(DocumentCommitProcessor.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PsiLock.LOCK;
                synchronized (object) {
                    file.getViewProvider().beforeContentsSynchronized();
                    Document document = file.getViewProvider().getDocument();
                    PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                    PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                    PsiFileImpl fileImpl = (PsiFileImpl)file;
                    if (transaction == null) {
                        final PomModel model = PomManager.getModel(fileImpl.getProject());
                        model.runTransaction(new PomTransactionBase(fileImpl, model.getModelAspect(TreeAspect.class)){

                            @Override
                            public PomModelEvent runInner() {
                                return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                            }
                        });
                    } else {
                        diffLog.performActualPsiChange(file);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull FileElement myTreeElementBeingReparsedSoItWontBeCollected) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (myTreeElementBeingReparsedSoItWontBeCollected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myTreeElementBeingReparsedSoItWontBeCollected", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file.getText();
            LOG.error("commitDocument left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file, document) + "; node len=" + myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() + "; doc.getText() == file.getText(): " + Comparing.equal(fileText, documentText), new Attachment("file psi text", fileText), new Attachment("old text", documentText));
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file, new TextRange(0, documentText.length()), documentText, this.createProgressIndicator(), myTreeElementBeingReparsedSoItWontBeCollected.getText());
                DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    public void log(@NonNls String msg2, @Nullable CommitTask task, boolean synchronously, Object ... args) {
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    protected static class CommitTask {
        @NotNull
        final Document document;
        @NotNull
        final Project project;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModalityState;
        private final CharSequence myLastCommittedText;
        public boolean removed;

        protected CommitTask(@NotNull Document document, @NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (currentModalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationModalityState = currentModalityState;
            this.myLastCommittedText = PsiDocumentManager.getInstance(project).getLastCommittedText(document);
        }

        @NonNls
        public String toString() {
            return "Project: " + this.project.getName() + ", Doc: " + this.document + " (" + StringUtil.first(this.document.getImmutableCharSequence(), 12, true).toString().replaceAll("\n", " ") + ")" + (this.indicator.isCanceled() ? " (Canceled)" : "") + (this.removed ? "Removed" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return this.document.equals(task.document) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.document.hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }
    }
}

