/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceService;
import org.jetbrains.kotlin.com.intellij.util.ProcessingContext;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class ReferenceProviderType {
    @NonNls
    public static final String EP_NAME = "org.jetbrains.kotlin.com.intellij.referenceProviderType";
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.ReferenceProviderType");
    private static final KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType> COLLECTOR = new KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType>("org.jetbrains.kotlin.com.intellij.referenceProviderType"){

        @Override
        @NotNull
        protected String keyToString(@NotNull ReferenceProviderType key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$1", "keyToString"));
            }
            String string = key.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$1", "keyToString"));
            }
            return string;
        }
    };
    private final String myId;

    public ReferenceProviderType(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType", "<init>"));
        }
        this.myId = id;
    }

    @NotNull
    public PsiReferenceProvider getProvider() {
        List<PsiReferenceProvider> list2 = COLLECTOR.forKey(this);
        LOG.assertTrue(!list2.isEmpty(), this.myId);
        PsiReferenceProvider psiReferenceProvider = list2.size() == 1 ? list2.get(0) : new CompositePsiReferenceProvider(list2);
        if (psiReferenceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType", "getProvider"));
        }
        return psiReferenceProvider;
    }

    public String toString() {
        return this.myId;
    }

    private static class CompositePsiReferenceProvider
    extends PsiReferenceProvider {
        private final List<PsiReferenceProvider> children;

        private CompositePsiReferenceProvider(@NotNull List<PsiReferenceProvider> children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "<init>"));
            }
            this.children = children;
        }

        @Override
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "getReferencesByElement"));
            }
            ArrayList<PsiReference> result2 = ContainerUtil.newArrayList();
            for (PsiReferenceProvider child : this.children) {
                ContainerUtil.addAllNotNull(result2, child.getReferencesByElement(element, context));
            }
            PsiReference[] psiReferenceArray = result2.toArray(new PsiReference[result2.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }

        @Override
        public boolean acceptsTarget(@NotNull PsiElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "acceptsTarget"));
            }
            for (PsiReferenceProvider child : this.children) {
                if (!child.acceptsTarget(target)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptsHints(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "acceptsHints"));
            }
            if (hints == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "org/jetbrains/kotlin/com/intellij/psi/ReferenceProviderType$CompositePsiReferenceProvider", "acceptsHints"));
            }
            for (PsiReferenceProvider child : this.children) {
                if (!child.acceptsHints(element, hints)) continue;
                return true;
            }
            return false;
        }
    }
}

