/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineTokenizer;
import org.jetbrains.kotlin.com.intellij.util.text.MergingCharSequence;
import org.jetbrains.kotlin.gnu.trove.TByteArrayList;
import org.jetbrains.kotlin.gnu.trove.TIntArrayList;

public class LineSet {
    private final int[] myStarts;
    private final byte[] myFlags;
    private final int myLength;
    private static boolean doTest = false;

    private LineSet(int[] starts, byte[] flags, int length) {
        this.myStarts = starts;
        this.myFlags = flags;
        this.myLength = length;
    }

    public static LineSet createLineSet(CharSequence text) {
        return LineSet.createLineSet(text, false);
    }

    private static LineSet createLineSet(CharSequence text, boolean markModified) {
        TIntArrayList starts = new TIntArrayList();
        TByteArrayList flags = new TByteArrayList();
        LineTokenizer lineTokenizer = new LineTokenizer(text);
        while (!lineTokenizer.atEnd()) {
            starts.add(lineTokenizer.getOffset());
            flags.add((byte)(lineTokenizer.getLineSeparatorLength() | (markModified ? 4 : 0)));
            lineTokenizer.advance();
        }
        return new LineSet(starts.toNativeArray(), flags.toNativeArray(), text.length());
    }

    LineSet update(CharSequence prevText, int _start, int _end, CharSequence replacement, boolean wholeTextReplaced) {
        if (this.myLength == 0) {
            return LineSet.createLineSet(replacement, !wholeTextReplaced);
        }
        int startOffset = _start;
        if (replacement.length() > 0 && replacement.charAt(0) == '\n' && startOffset > 0 && prevText.charAt(startOffset - 1) == '\r') {
            --startOffset;
        }
        int startLine = this.findLineIndex(startOffset);
        startOffset = this.getLineStart(startLine);
        int endOffset = _end;
        if (replacement.length() > 0 && replacement.charAt(replacement.length() - 1) == '\r' && endOffset < prevText.length() && prevText.charAt(endOffset) == '\n') {
            ++endOffset;
        }
        int endLine = this.findLineIndex(endOffset);
        endOffset = this.getLineEnd(endLine);
        if (!this.isLastEmptyLine(endLine)) {
            ++endLine;
        }
        replacement = new MergingCharSequence(new MergingCharSequence(prevText.subSequence(startOffset, _start), replacement), prevText.subSequence(_end, endOffset));
        LineSet patch = LineSet.createLineSet(replacement, true);
        LineSet applied = this.applyPatch(startOffset, endOffset, startLine, endLine, patch);
        if (doTest) {
            MergingCharSequence newText = new MergingCharSequence(new MergingCharSequence(prevText.subSequence(0, startOffset), replacement), prevText.subSequence(endOffset, prevText.length()));
            applied.checkEquals(LineSet.createLineSet(newText));
        }
        return wholeTextReplaced ? applied.clearModificationFlags() : applied;
    }

    private void checkEquals(LineSet fresh) {
        if (this.getLineCount() != fresh.getLineCount()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.getLineCount(); ++i) {
            boolean sep;
            boolean start = this.getLineStart(i) != fresh.getLineStart(i);
            boolean end = this.getLineEnd(i) != fresh.getLineEnd(i);
            boolean bl = sep = this.getSeparatorLength(i) != fresh.getSeparatorLength(i);
            if (start || end || sep) {
                throw new AssertionError();
            }
        }
    }

    @NotNull
    private LineSet applyPatch(int startOffset, int endOffset, int startLine, int endLine, LineSet patch) {
        int i;
        int lineShift = patch.myStarts.length - (endLine - startLine);
        int lengthShift = patch.myLength - (endOffset - startOffset);
        int newLineCount = this.myStarts.length + lineShift;
        int[] starts = new int[newLineCount];
        byte[] flags = new byte[newLineCount];
        for (i = 0; i < startLine; ++i) {
            starts[i] = this.myStarts[i];
            flags[i] = this.myFlags[i];
        }
        for (i = 0; i < patch.myStarts.length; ++i) {
            starts[startLine + i] = patch.myStarts[i] + startOffset;
            flags[startLine + i] = patch.myFlags[i];
        }
        for (i = endLine; i < this.myStarts.length; ++i) {
            starts[lineShift + i] = this.myStarts[i] + lengthShift;
            flags[lineShift + i] = this.myFlags[i];
        }
        LineSet lineSet = new LineSet(starts, flags, this.myLength + lengthShift);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/LineSet", "applyPatch"));
        }
        return lineSet;
    }

    public int findLineIndex(int offset2) {
        if (offset2 < 0 || offset2 > this.myLength) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset2 + ". Should be in range: [0, " + this.myLength + "]");
        }
        if (this.myLength == 0) {
            return 0;
        }
        if (offset2 == this.myLength) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myStarts, offset2);
        return bsResult >= 0 ? bsResult : -bsResult - 2;
    }

    public final int getLineStart(int index2) {
        this.checkLineIndex(index2);
        return this.isLastEmptyLine(index2) ? this.myLength : this.myStarts[index2];
    }

    private boolean isLastEmptyLine(int index2) {
        return index2 == this.myFlags.length && index2 > 0 && (this.myFlags[index2 - 1] & 3) > 0;
    }

    public final int getLineEnd(int index2) {
        this.checkLineIndex(index2);
        return index2 >= this.myStarts.length - 1 ? this.myLength : this.myStarts[index2 + 1];
    }

    private void checkLineIndex(int index2) {
        if (index2 < 0 || index2 >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index2 + ". Available lines count: " + this.getLineCount());
        }
    }

    LineSet clearModificationFlags() {
        byte[] flags = (byte[])this.myFlags.clone();
        int i = 0;
        while (i < flags.length) {
            int n = i++;
            flags[n] = (byte)(flags[n] & 0xFFFFFFFB);
        }
        return new LineSet(this.myStarts, flags, this.myLength);
    }

    final int getSeparatorLength(int index2) {
        this.checkLineIndex(index2);
        return index2 < this.myFlags.length ? this.myFlags[index2] & 3 : 0;
    }

    final int getLineCount() {
        return this.myStarts.length + (this.isLastEmptyLine(this.myStarts.length) ? 1 : 0);
    }
}

