/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedSimple;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithFakeAnnotations;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassContextBase;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @NotNull MemberCodegen<?> memberCodegen) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (functionCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCodegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (memberCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberCodegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        this.state = functionCodegen.state;
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context;
        this.memberCodegen = memberCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/PropertyCodegen", "gen"));
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property);
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedProperty", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateInPackageFacade"));
        }
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter, @Nullable KtPropertyAccessor setter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "gen"));
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        assert (declaration != null) : "Declaration is null: " + descriptor2 + " (context=" + this.context + ")";
        this.genBackingFieldAndAnnotations(declaration, descriptor2, false);
        if (this.isAccessorNeeded(declaration, descriptor2, getter)) {
            this.generateGetter(declaration, descriptor2, getter);
        }
        if (this.isAccessorNeeded(declaration, descriptor2, setter)) {
            this.generateSetter(declaration, descriptor2, setter);
        }
    }

    private void genBackingFieldAndAnnotations(@NotNull KtNamedDeclaration declaration, @NotNull PropertyDescriptor descriptor2, boolean isParameter) {
        boolean isBackingFieldOwner;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genBackingFieldAndAnnotations"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genBackingFieldAndAnnotations"));
        }
        boolean hasBackingField = this.hasBackingField(declaration, descriptor2);
        boolean hasDelegate = declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate();
        AnnotationSplitter annotationSplitter = AnnotationSplitter.create(LockBasedStorageManager.NO_LOCKS, descriptor2.getAnnotations(), AnnotationSplitter.getTargetSet(isParameter, descriptor2.isVar(), hasBackingField, hasDelegate));
        Annotations propertyAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY);
        boolean bl = descriptor2.isConst() && !Visibilities.isPrivate(descriptor2.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : (isBackingFieldOwner = CodegenContextUtil.isImplClassOwner(this.context));
        if (isBackingFieldOwner) {
            Annotations fieldAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD);
            Annotations delegateAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            this.generateBackingField(declaration, descriptor2, fieldAnnotations, delegateAnnotations);
            this.generateSyntheticMethodIfNeeded(descriptor2, propertyAnnotations);
        }
        if (!propertyAnnotations.getAllAnnotations().isEmpty() && this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplClassOwner(this.context)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, this.getSyntheticMethodSignature(descriptor2));
        }
    }

    private boolean isAccessorNeeded(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor accessor) {
        boolean isDefaultAccessor;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "isAccessorNeeded"));
        }
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        boolean bl = isDefaultAccessor = accessor == null || !accessor.hasBody();
        if (this.kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (declaration == null) {
            return true;
        }
        if (declaration.hasDelegate() || declaration.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return true;
        }
        if (!descriptor2.isConst() && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration)) {
            return true;
        }
        if (Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "areAccessorsNeededForPrimaryConstructorProperty"));
        }
        if (AnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        return !Visibilities.isPrivate(descriptor2.getVisibility());
    }

    public void generatePrimaryConstructorProperty(@NotNull KtParameter p, @NotNull PropertyDescriptor descriptor2) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generatePrimaryConstructorProperty"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generatePrimaryConstructorProperty"));
        }
        this.genBackingFieldAndAnnotations(p, descriptor2, true);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor2)) {
            this.generateGetter(p, descriptor2, null);
            this.generateSetter(p, descriptor2, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(KtParameter p, PropertyDescriptor descriptor2) {
        JvmMethodGenericSignature signature2 = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        String name = p.getName();
        if (name == null) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(p, descriptor2), 1025, name, signature2.getAsmMethod().getDescriptor(), signature2.getGenericsSignature(), null);
        KtExpression defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext, true);
            assert (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.typeMapper);
                annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
            }
        }
        mv.visitEnd();
    }

    private boolean hasBackingField(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "hasBackingField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "hasBackingField"));
        }
        return !JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) && this.kind != OwnerKind.DEFAULT_IMPLS && !Boolean.FALSE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2));
    }

    private boolean generateBackingField(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @NotNull Annotations backingFieldAnnotations, @NotNull Annotations delegateAnnotations) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (backingFieldAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldAnnotations", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (delegateAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnnotations", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            return false;
        }
        if (p instanceof KtProperty && ((KtProperty)p).hasDelegate()) {
            this.generatePropertyDelegateAccess((KtProperty)p, descriptor2, delegateAnnotations);
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            this.generateBackingFieldAccess(p, descriptor2, backingFieldAnnotations);
        } else {
            return false;
        }
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2, @NotNull Annotations annotations2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateSyntheticMethodIfNeeded"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateSyntheticMethodIfNeeded"));
        }
        if (annotations2.getAllAnnotations().isEmpty()) {
            return;
        }
        if (!DescriptorUtils.isInterface(this.context.getContextDescriptor()) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            int flags = 135194;
            Method syntheticMethod = this.getSyntheticMethodSignature(descriptor2);
            MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), flags, syntheticMethod.getName(), syntheticMethod.getDescriptor(), null, null);
            AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(new AnnotatedSimple(annotations2), Type.VOID_TYPE, AnnotationUseSiteTarget.PROPERTY);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitEnd();
        }
    }

    @NotNull
    private Method getSyntheticMethodSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "getSyntheticMethodSignature"));
        }
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor2.getName());
        String desc = receiver == null ? "()V" : "(" + this.typeMapper.mapType(receiver.getType()) + ")V";
        Method method = new Method(name, desc);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/PropertyCodegen", "getSyntheticMethodSignature"));
        }
        return method;
    }

    private void generateBackingField(KtNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, KotlinType kotlinType, Object defaultValue, Annotations annotations2) {
        int modifiers = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(propertyDescriptor.getOriginal())) continue;
            modifiers |= flagAnnotation.getJvmFlag();
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers |= 8;
        }
        if (!(propertyDescriptor.isLateInit() || propertyDescriptor.isVar() && !isDelegate)) {
            modifiers |= 0x10;
        }
        if (org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor)) {
            modifiers |= 0x1000;
        }
        Type type2 = this.typeMapper.mapType(kotlinType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers |= 8;
            if (JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen.v;
                backingFieldContext = codegen.context;
            }
        }
        modifiers |= AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegate);
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create(type2, name));
        FieldVisitor fv = builder.newField(JvmDeclarationOriginKt.OtherOrigin(element, propertyDescriptor), modifiers, name, type2.getDescriptor(), isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType, propertyDescriptor), defaultValue);
        AnnotatedWithFakeAnnotations fieldAnnotated = new AnnotatedWithFakeAnnotations(propertyDescriptor, annotations2);
        AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(fieldAnnotated, type2, isDelegate ? AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD : AnnotationUseSiteTarget.FIELD);
    }

    private void generatePropertyDelegateAccess(@NotNull KtProperty p, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        KotlinType delegateType;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generatePropertyDelegateAccess"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generatePropertyDelegateAccess"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generatePropertyDelegateAccess"));
        }
        KtExpression delegateExpression = p.getDelegateExpression();
        KotlinType kotlinType = delegateType = delegateExpression != null ? this.bindingContext.getType(p.getDelegateExpression()) : null;
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        this.generateBackingField(p, propertyDescriptor, true, delegateType, null, annotations2);
    }

    private void generateBackingFieldAccess(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        ConstantValue<?> initializer2;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingFieldAccess"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingFieldAccess"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingFieldAccess"));
        }
        Object value = null;
        if (this.shouldWriteFieldInitializer(propertyDescriptor) && (initializer2 = propertyDescriptor.getCompileTimeInitializer()) != null) {
            value = initializer2.getValue();
        }
        this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value, annotations2);
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "shouldWriteFieldInitializer"));
        }
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateGetter"));
        }
        this.generateAccessor(p, getter, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor setter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateSetter"));
        }
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(p, setter, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtNamedDeclaration p, @Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateAccessor"));
        }
        if (this.context instanceof MultifileClassFacadeContext && Visibilities.isPrivate(accessorDescriptor.getVisibility())) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (p instanceof KtProperty && ((KtProperty)p).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor, PropertyCodegen.indexOfDelegatedProperty((KtProperty)p)) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessorDescriptor, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(accessor != null ? accessor : p, accessorDescriptor), accessorDescriptor, strategy);
    }

    public static int indexOfDelegatedProperty(@NotNull KtProperty property) {
        ElementBase container;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/PropertyCodegen", "indexOfDelegatedProperty"));
        }
        PsiElement parent2 = property.getParent();
        if (parent2 instanceof KtClassBody) {
            container = (KtClassOrObject)parent2.getParent();
        } else if (parent2 instanceof KtFile) {
            container = (KtFile)parent2;
        } else {
            throw new UnsupportedOperationException("Unknown delegated property container: " + parent2);
        }
        int index2 = 0;
        for (KtDeclaration declaration : container.getDeclarations()) {
            if (!(declaration instanceof KtProperty) || !((KtProperty)declaration).hasDelegate()) continue;
            if (declaration == property) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalStateException("Delegated property not found in its parent: " + PsiUtilsKt.getElementTextWithContext(property));
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull ExpressionCodegen codegen, @NotNull KotlinTypeMapper typeMapper, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, final int indexInPropertyMetadataArray, int propertyMetadataArgumentIndex) {
        Type owner;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        CodegenContext<ClassOrPackageFragmentDescriptor> ownerContext = codegen.getContext().getClassOrPackageParentContext();
        if (ownerContext instanceof ClassContext) {
            owner = typeMapper.mapClass((ClassifierDescriptor)((ClassContext)ownerContext).getContextDescriptor());
        } else if (ownerContext instanceof PackageContext) {
            owner = ((PackageContext)ownerContext).getPackagePartType();
        } else if (ownerContext instanceof MultifileClassContextBase) {
            owner = ((MultifileClassContextBase)ownerContext).getFilePartType();
        } else {
            throw new UnsupportedOperationException("Unknown context: " + ownerContext);
        }
        codegen.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(propertyMetadataArgumentIndex).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/PropertyCodegen$1", "putSelector"));
                }
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/PropertyCodegen$1", "putSelector"));
                }
                StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
                StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, array, StackValue.constant(indexInPropertyMetadataArray, Type.INT_TYPE)).put(type2, v);
            }
        });
        StackValue.Property delegatedProperty = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
        return codegen.invokeFunction(resolvedCall2, delegatedProperty);
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate2, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter;
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter = delegate2.getGetter();
        if (getter != null) {
            this.functionCodegen.genDelegate(getter, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter = delegate2.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        private final int index;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2, int index2) {
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            super(state2, descriptor2);
            this.index = index2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.callableDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature2.toString();
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty(), codegen, this.state.getTypeMapper(), resolvedCall2, this.index, 1);
            Type asmType = signature2.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            super(state2, descriptor2);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (jetProperty instanceof KtProperty || jetProperty instanceof KtParameter) {
                codegen.markLineNumber((KtElement)jetProperty, false);
            }
            if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature2.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.callableDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters = ((PropertyAccessorDescriptor)this.callableDescriptor).getValueParameters();
                assert (valueParameters.size() == 1) : "Property setter should have only one value parameter but has " + this.callableDescriptor;
                int parameterIndex = codegen.lookupLocalIndex(valueParameters.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.callableDescriptor;
                Type type3 = codegen.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.callableDescriptor);
            }
        }
    }
}

