/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "factory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "packageFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;Ljava/util/Collection;)V", "allDeclaredSubPackages", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "doCreateIndex", "", "index", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "getAllDeclaredSubPackages", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getPackageFiles", "toString", "", "kotlin-compiler"})
public final class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;
    private final FqName fqName;
    private final FileBasedDeclarationProviderFactory factory;
    private final Collection<KtFile> packageFiles;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index2) {
        Intrinsics.checkParameterIsNotNull(index2, "index");
        for (KtFile file : this.packageFiles) {
            for (KtDeclaration declaration : file.getDeclarations()) {
                Unit unit;
                boolean bl = Intrinsics.areEqual(this.fqName, file.getPackageFqName());
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Files declaration utils contains file with invalid package";
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                KtDeclaration ktDeclaration = declaration;
                Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "declaration");
                index2.putToIndex(ktDeclaration);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages(@NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        return (Collection)this.allDeclaredSubPackages.invoke();
    }

    @Override
    @NotNull
    public Collection<KtFile> getPackageFiles() {
        return this.packageFiles;
    }

    @NotNull
    public String toString() {
        return "Declarations for package " + this.fqName;
    }

    public FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName fqName2, @NotNull FileBasedDeclarationProviderFactory factory, @NotNull Collection<? extends KtFile> packageFiles) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(factory, "factory");
        Intrinsics.checkParameterIsNotNull(packageFiles, "packageFiles");
        super(storageManager);
        this.fqName = fqName2;
        this.factory = factory;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue((Function0)new Function0<Collection<FqName>>(this){
            final /* synthetic */ FileBasedPackageMemberDeclarationProvider this$0;

            public final Collection<FqName> invoke() {
                Collection<FqName> collection = FileBasedPackageMemberDeclarationProvider.access$getFactory$p(this.this$0).getAllDeclaredSubPackagesOf(FileBasedPackageMemberDeclarationProvider.access$getFqName$p(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull(collection, "factory.getAllDeclaredSubPackagesOf(fqName)");
                return collection;
            }
            {
                this.this$0 = fileBasedPackageMemberDeclarationProvider;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ FileBasedDeclarationProviderFactory access$getFactory$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getFqName$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.fqName;
    }
}

