/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.InfixValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0013\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00112\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0016\u0010\"\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0001\u001a\u001e\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0012\u0010'\u001a\u00020\u0019*\u00020\n2\u0006\u0010(\u001a\u00020)\u001a\u0014\u0010*\u001a\u00020\u0019*\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002\u00a8\u0006+"}, d2={"getEffectiveExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getParameterArgumentsOfCallableType", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "kotlin.jvm.PlatformType", "type", "getReturnTypeForCallable", "Lorg/jetbrains/annotations/NotNull;", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "getUnaryPlusOrMinusOperatorFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "hasUnknownFunctionParameter", "", "hasUnknownReturnType", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "kotlin-compiler"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block4: {
            Unit unit;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean value$iv = ReflectionTypes.Companion.isCallableType(type2);
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv = "type " + type2 + " is not a function or property";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            Iterable $receiver$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(TypeUtils.contains(it.getType(), TypeUtils.DONT_CARE) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value$iv = ReflectionTypes.Companion.isCallableType(type2);
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(given, "given");
        boolean value$iv = ReflectionTypes.Companion.isCallableType(type2);
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        ArrayList<TypeProjectionImpl> newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        List list2 = newArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, list2);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KotlinType kotlinType = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, kotlinType);
    }

    private static final KotlinTypeImpl replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments) {
        Annotations annotations2 = type2.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "type.annotations");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.constructor");
        boolean bl = type2.isMarkedNullable();
        MemberScope memberScope2 = type2.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "type.memberScope");
        return KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, bl, newArguments, memberScope2);
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return CollectionsKt.last(type2.getArguments()).getType();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $receiver, ConstraintSystem constraintSystem) {
        boolean bl;
        block2: {
            void $receiver$iv;
            KotlinType returnType2;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType kotlinType2 = returnType2 = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "returnType");
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, kotlinType2);
            Iterable iterable = nestedTypeVariables;
            for (Object element$iv : $receiver$iv) {
                TypeVariable it = (TypeVariable)element$iv;
                if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        KotlinType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual(typeParameter.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = TypeIntersector.getUpperBoundsAsType(typeParameter);
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        Annotations annotations2 = receiverType.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "receiverType.annotations");
        TypeConstructor typeConstructor2 = receiverType.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "receiverType.constructor");
        boolean bl = receiverType.isMarkedNullable();
        List list2 = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "fakeTypeArguments");
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, bl, list2, memberScope2);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = descriptor2.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    CallableMemberDescriptor it;
                    CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isConventionCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement callElement = call.getCallElement();
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return KtOperationReferenceExpression.getNameForConventionalOperation$default(calleeExpression, false, false, 3, null) != null;
    }

    public static final boolean isInfixCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return InfixValidator.Companion.isInfixCall(call.getCalleeExpression());
    }

    @Nullable
    public static final Name getUnaryPlusOrMinusOperatorFunctionName(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (!(call.getCallElement() instanceof KtPrefixExpression)) {
            return null;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return null;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        Name name = calleeExpression.getNameForConventionalOperation(true, false);
        return Intrinsics.areEqual(name, OperatorNameConventions.UNARY_PLUS) || Intrinsics.areEqual(name, OperatorNameConventions.UNARY_MINUS) ? name : (Name)null;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
        return expression instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver() != null && call.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        Receiver receiver = call.getExplicitReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            receiver = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiver;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                KotlinType kotlinType = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "DONT_CARE");
                return kotlinType;
            }
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
            return kotlinType;
        }
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        KotlinType kotlinType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
        return kotlinType;
    }
}

