/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.SubstitutionFilteringInternalResolveAnnotations;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001XB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ*\u0010\u0013\u001a\u00060\u0014R\u00020\u0000\"\b\b\u0000\u0010\u0015*\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00102\u0006\u0010\u0017\u001a\u00020\u0018J<\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020&2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010'\u001a\u00020(\"\b\b\u0000\u0010\u0015*\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0010H\u0002JJ\u0010)\u001a\u00060\u0014R\u00020\u0000\"\b\b\u0000\u0010\u0015*\u00020\u000f\"\u000e\b\u0001\u0010**\b\u0012\u0004\u0012\u0002H*0+2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H*0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00150-2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0014\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000104H\u0002J0\u00105\u001a\u00020\u001a\"\b\b\u0000\u0010\u0015*\u00020\u000f\"\b\b\u0001\u00106*\u0002H\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00102\u0006\u00107\u001a\u000208J.\u00109\u001a\u0004\u0018\u00010\u001f2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030>H\u0002J<\u0010?\u001a\u00020\u001a\"\b\b\u0000\u0010\u0015*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u00150\u00102\u001d\u0010@\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u0010\u0012\u0004\u0012\u00020\u001a0A\u00a2\u0006\u0002\bBH\u0082\bJ\u0010\u0010C\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J<\u0010D\u001a\u00020\u001a\"\b\b\u0000\u0010\u0015*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u00150\u00102\u001d\u0010@\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u0010\u0012\u0004\u0012\u00020(0A\u00a2\u0006\u0002\bBH\u0082\bJ\u0010\u0010E\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J&\u0010F\u001a\u00020\u001a\"\b\b\u0000\u0010\u0015*\u00020\u000f\"\b\b\u0001\u00106*\u0002H\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0010H\u0002J\u0010\u0010G\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0010\u0010H\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002JN\u0010I\u001a\u00020(\"\b\b\u0000\u0010\u0015*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u00150\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00150J2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020&H\u0002J\u0010\u0010Q\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J$\u0010Q\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u00102\b\u0010R\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\u0010\u0010S\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0010\u0010T\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J&\u0010U\u001a\u00020\u001a\"\b\b\u0000\u0010\u0015*\u00020\u000f\"\b\b\u0001\u00106*\u0002H\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0010H\u0002J\u0010\u0010V\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010W\u001a\u00020&\"\b\b\u0000\u0010\u0015*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u00150\u0010H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "genericCandidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "additionalTypeCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "smartCastManager", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;)V", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "getCandidateDescriptor", "(Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkAllValueArguments", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "D", "context", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "checkGenericBoundsInAFunctionCall", "", "jetTypeArguments", "", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "typeArguments", "Lorg/jetbrains/kotlin/types/KotlinType;", "functionDescriptor", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkOuterClassMemberIsAccessible", "", "checkReceivers", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "checkValueArgumentTypes", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "candidateCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "getDeclaringClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "candidate", "getReceiverSuper", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "performResolutionForCandidateCall", "F", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "smartCastValueArgumentTypeIfPossible", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "actualType", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "check", "checker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "checkAbstractAndSuper", "checkAndReport", "checkDispatchReceiver", "checkExpectedCallableType", "checkExtensionReceiver", "checkNonExtensionCalledWithReceiver", "checkReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "isExplicitReceiver", "implicitInvokeCheck", "checkReceiverTypeError", "receiverParameterDescriptor", "checkValueArguments", "checkVisibility", "mapArguments", "processTypeArguments", "shouldContinue", "ValueArgumentsCheckingResult", "kotlin-compiler"})
public final class CandidateResolver {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final GenericCandidateResolver genericCandidateResolver;
    private final ReflectionTypes reflectionTypes;
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final SmartCastManager smartCastManager;

    public final <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull CheckArgumentTypesMode checkArguments) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)checkArguments, "checkArguments");
        CallCandidateResolutionContext<D> $receiver = context;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (ErrorUtils.isError(this.getCandidateDescriptor($receiver))) {
            $receiver.candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!this.checkOuterClassMemberIsAccessible($receiver)) {
            $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        this.checkVisibility($receiver);
        switch (CandidateResolver$WhenMappings.$EnumSwitchMapping$0[checkArguments.ordinal()]) {
            case 1: {
                this.mapArguments($receiver);
                break;
            }
            case 2: {
                this.checkExpectedCallableType($receiver);
            }
        }
        this.checkReceiverTypeError($receiver);
        this.checkExtensionReceiver($receiver);
        this.checkDispatchReceiver($receiver);
        this.processTypeArguments($receiver);
        this.checkValueArguments($receiver);
        this.checkAbstractAndSuper($receiver);
        this.checkNonExtensionCalledWithReceiver($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkValueArguments(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = $receiver2.call.getTypeArguments().isEmpty() && !this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2).getTypeParameters().isEmpty() && $receiver2.candidateCall.getKnownTypeParametersSubstitutor() == null ? this.genericCandidateResolver.inferTypeArguments($receiver2) : this.checkAllValueArguments((CallCandidateResolutionContext)$receiver2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).getStatus();
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTypeArguments(CallCandidateResolutionContext<?> $receiver) {
        block10: {
            TypeSubstitution substitution;
            int type22;
            List<KtTypeProjection> jetTypeArguments;
            CallCandidateResolutionContext $receiver2;
            block11: {
                void $receiver$iv;
                CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
                CandidateResolver this_$iv = this;
                if (!this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) break block10;
                $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
                jetTypeArguments = $receiver2.call.getTypeArguments();
                if ($receiver2.candidateCall.getKnownTypeParametersSubstitutor() == null) break block11;
                MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
                TypeSubstitutor typeSubstitutor2 = $receiver2.candidateCall.getKnownTypeParametersSubstitutor();
                if (typeSubstitutor2 == null) {
                    Intrinsics.throwNpe();
                }
                mutableResolvedCall.setResultingSubstitutor(typeSubstitutor2);
                break block10;
            }
            if (jetTypeArguments.isEmpty()) break block10;
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (KtTypeProjection projection : jetTypeArguments) {
                Object object;
                block13: {
                    block12: {
                        void $receiver$iv;
                        object = projection.getTypeReference();
                        if (object == null) break block12;
                        KtTypeReference ktTypeReference = object;
                        KtTypeReference it = (KtTypeReference)$receiver$iv;
                        object = (KotlinType)$receiver2.trace.getBindingContext().get(BindingContext.TYPE, it);
                        if (object != null) break block13;
                    }
                    object = ErrorUtils.createErrorType("Star projection in a call");
                }
                Object type22 = object;
                typeArguments.add(type22);
            }
            int expectedTypeArgumentCount = this.getCandidateDescriptor($receiver2).getTypeParameters().size();
            int n = jetTypeArguments.size();
            if (n <= (type22 = expectedTypeArgumentCount - 1)) {
                while (true) {
                    void index2;
                    typeArguments.add(ErrorUtils.createErrorType("Explicit type argument expected for " + this.getCandidateDescriptor($receiver2).getTypeParameters().get((int)index2).getName()));
                    if (index2 == type22) break;
                    ++index2;
                }
            }
            CallableDescriptor callableDescriptor = this.getCandidateDescriptor($receiver2);
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            TypeSubstitution typeSubstitution = substitution = FunctionDescriptorUtil.createSubstitution((FunctionDescriptor)callableDescriptor, (List<KotlinType>)typeArguments);
            Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "substitution");
            TypeSubstitutor substitutor2 = TypeSubstitutor.create(new SubstitutionFilteringInternalResolveAnnotations(typeSubstitution));
            if (expectedTypeArgumentCount != jetTypeArguments.size()) {
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                $receiver2.tracing.wrongNumberOfTypeArguments($receiver2.trace, expectedTypeArgumentCount);
            } else {
                List<KtTypeProjection> list2 = jetTypeArguments;
                Intrinsics.checkExpressionValueIsNotNull(list2, "jetTypeArguments");
                List list3 = typeArguments;
                CallableDescriptor callableDescriptor2 = this.getCandidateDescriptor($receiver2);
                TypeSubstitutor typeSubstitutor3 = substitutor2;
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor3, "substitutor");
                BindingTrace bindingTrace = $receiver2.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                this.checkGenericBoundsInAFunctionCall(list2, list3, callableDescriptor2, typeSubstitutor3, bindingTrace);
            }
            $receiver2.candidateCall.setResultingSubstitutor(substitutor2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void mapArguments(CallCandidateResolutionContext<D> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters($receiver2.call, $receiver2.tracing, $receiver2.candidateCall, Sets.newLinkedHashSet());
            if (!argumentMappingStatus.isSuccess()) {
                $receiver2.candidateCall.addStatus(ResolutionStatus.ARGUMENTS_MAPPING_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void checkExpectedCallableType(CallCandidateResolutionContext<D> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            if (!TypeUtils.noExpectedType($receiver2.expectedType)) {
                Object candidate;
                Object d = candidate = $receiver2.candidateCall.getCandidateDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, "candidate");
                KotlinType candidateReflectionType = CallableReferencesResolutionUtilsKt.getReflectionTypeForCandidateDescriptor(d, this.reflectionTypes);
                if (candidateReflectionType != null) {
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateReflectionType, $receiver2.expectedType)) {
                        $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                    }
                } else {
                    $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember($receiver2.candidateCall.getDispatchReceiver(), this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2), $receiver2.scope.getOwnerDescriptor());
            if (invisibleMember != null) {
                $receiver2.tracing.invisibleMember($receiver2.trace, invisibleMember);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExtensionReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ReceiverParameterDescriptor receiverParameter = $receiver2.candidateCall.getCandidateDescriptor().getExtensionReceiverParameter();
            Receiver receiverArgument = $receiver2.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && receiverArgument == null) {
                $receiver2.tracing.missingReceiver($receiver2.candidateCall.getTrace(), receiverParameter);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else if (receiverParameter == null && receiverArgument != null) {
                $receiver2.tracing.noReceiverAllowed($receiver2.candidateCall.getTrace());
                resolutionStatus = $receiver2.call.getCalleeExpression() instanceof KtSimpleNameExpression ? ResolutionStatus.RECEIVER_PRESENCE_ERROR : ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDispatchReceiver(CallCandidateResolutionContext<?> $receiver) {
        block8: {
            var2_2 = $receiver;
            this_$iv = this;
            if (!CandidateResolver.access$shouldContinue(this_$iv, (CallCandidateResolutionContext)$receiver$iv)) break block8;
            var4_4 = (CallCandidateResolutionContext)$receiver$iv;
            var5_5 = $receiver$iv.candidateCall;
            candidateDescriptor = this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver);
            dispatchReceiver = $receiver.candidateCall.getDispatchReceiver();
            if (dispatchReceiver == null) ** GOTO lbl-1000
            nestedClass = null;
            if (candidateDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration())) {
                nestedClass = ((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedDescriptor();
            }
            if (nestedClass != null) {
                $receiver.tracing.nestedClassAccessViaInstanceReference($receiver.trace, nestedClass, $receiver.candidateCall.getExplicitReceiverKind());
                v0 = ResolutionStatus.OTHER_ERROR;
            } else lbl-1000:
            // 2 sources

            {
                nestedClass = dispatchReceiver != null == ($receiver.candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null);
                if (_Assertions.ENABLED) {
                    if (value$iv == false) {
                        message$iv = "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
                        throw (Throwable)new AssertionError((Object)message$iv);
                    }
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = Unit.INSTANCE;
                }
                v0 = ResolutionStatus.SUCCESS;
            }
            var10_11 = v0;
            var5_5.addStatus(var10_11);
        }
    }

    private final boolean checkOuterClassMemberIsAccessible(CallCandidateResolutionContext<?> context) {
        if (context.call.getExplicitReceiver() != null || context.call.getDispatchReceiver() != null) {
            return true;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "context.candidateCall.getCandidateDescriptor()");
        ClassDescriptor candidateThis = this.getDeclaringClass((CallableDescriptor)d);
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAbstractAndSuper(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            KtSuperExpression superExtensionReceiver;
            KtSuperExpression superDispatchReceiver;
            Modality modality;
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            CallableDescriptor descriptor2 = this.getCandidateDescriptor($receiver2);
            KtExpression expression = $receiver2.candidateCall.getCall().getCalleeExpression();
            if (expression instanceof KtSimpleNameExpression && descriptor2 instanceof ConstructorDescriptor && Intrinsics.areEqual((Object)(modality = ((ConstructorDescriptor)descriptor2).getContainingDeclaration().getModality()), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.instantiationOfAbstractClass($receiver2.trace);
            }
            if ((superDispatchReceiver = this.getReceiverSuper($receiver2.candidateCall.getDispatchReceiver())) != null && descriptor2 instanceof MemberDescriptor && Intrinsics.areEqual((Object)((MemberDescriptor)((Object)descriptor2)).getModality(), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.abstractSuperCall($receiver2.trace);
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            if ((superExtensionReceiver = this.getReceiverSuper($receiver2.candidateCall.getExtensionReceiver())) != null) {
                $receiver2.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((KtSuperExpression)((PsiElement)superExtensionReceiver), superExtensionReceiver.getText()));
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonExtensionCalledWithReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            Call call = $receiver2.candidateCall.getCall();
            if (call instanceof CallTransformer.CallForImplicitInvoke && $receiver2.candidateCall.getExtensionReceiver() != null && $receiver2.candidateCall.getDispatchReceiver() != null && Intrinsics.areEqual(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver(), $receiver2.candidateCall.getDispatchReceiver()) && !KotlinBuiltIns.isExactExtensionFunctionType(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver().getType())) {
                $receiver2.tracing.nonExtensionFunctionCalledAsExtension($receiver2.trace);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final KtSuperExpression getReceiverSuper(Receiver receiver) {
        KtExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = ((ExpressionReceiver)receiver).getExpression()) instanceof KtSuperExpression) {
            return (KtSuperExpression)expression;
        }
        return null;
    }

    private final ClassDescriptor getDeclaringClass(CallableDescriptor candidate) {
        ReceiverParameterDescriptor receiverParameterDescriptor = candidate.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThis = receiverParameterDescriptor;
        DeclarationDescriptor descriptor2 = expectedThis.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : (ClassDescriptor)null;
    }

    @NotNull
    public final <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        CallResolutionContext callResolutionContext = context;
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(callResolutionContext, mutableResolvedCall, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.getStatus();
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceivers(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(checkReceivers(context))");
        resultStatus = resolutionStatus;
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.getArgumentTypes());
    }

    private final <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(CallResolutionContext<C> context, MutableResolvedCall<D> candidateCall, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<KotlinType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                KtExpression expression;
                if (argument.getArgumentExpression() == null) {
                    continue;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
                ValueArgument valueArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceExpectedType(expectedType);
                KotlinTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                KotlinType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                KotlinType resultingType = type2;
                if (type2 == null || type2.isError() && !FunctionPlaceholdersKt.isFunctionPlaceholder(type2)) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType)) {
                    DataFlowValue dataFlowValue;
                    SmartCastResult smartCastResult;
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType)) {
                        KotlinType kotlinType = newContext.expectedType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "newContext.expectedType");
                        ResolutionContext resolutionContext = newContext;
                        Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "newContext");
                        KotlinType smartCast = this.smartCastValueArgumentTypeIfPossible(expression, kotlinType, type2, resolutionContext);
                        if (smartCast == null) {
                            resultStatus = ResolutionStatus.OTHER_ERROR;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCast;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                    LeafPsiElement spreadElement = argument.getSpreadElement();
                    if (!(spreadElement == null || FlexibleTypesKt.isFlexible(type2) || !type2.isMarkedNullable() || (smartCastResult = SmartCastManager.checkAndRecordPossibleCast(dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context), expectedType, expression, context, null, false)) != null && smartCastResult.isCorrect())) {
                        context.trace.report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
                    }
                }
                argumentTypes.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        List list2 = argumentTypes;
        Intrinsics.checkExpressionValueIsNotNull(list2, "argumentTypes");
        return new ValueArgumentsCheckingResult(resultStatus, list2);
    }

    private final KotlinType smartCastValueArgumentTypeIfPossible(KtExpression expression, KotlinType expectedType, KotlinType actualType, ResolutionContext<?> context) {
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(expression);
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "KtPsiUtil.safeDeparenthesize(expression)");
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        ExpressionReceiver receiverToCast = ExpressionReceiver.Companion.create(ktExpression, actualType, bindingContext);
        Collection<KotlinType> variants = this.smartCastManager.getSmartCastVariantsExcludingReceiver(context, receiverToCast);
        for (KotlinType possibleType : variants) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            ReceiverParameterDescriptor extensionReceiver2 = this.getCandidateDescriptor($receiver2).getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.getCandidateDescriptor($receiver2).getDispatchReceiverParameter();
            Call call = $receiver2.call;
            Intrinsics.checkExpressionValueIsNotNull(call, "call");
            if (!CallResolverUtilKt.isInvokeCallOnExpressionWithBothReceivers(call)) {
                Unit unit;
                Receiver callExtensionReceiver;
                Receiver receiver = callExtensionReceiver = $receiver2.candidateCall.getExtensionReceiver();
                boolean bl = receiver != null ? receiver instanceof ReceiverValue : true;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Expected ReceiverValue, got " + callExtensionReceiver;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                this.checkReceiverTypeError($receiver2, extensionReceiver2, (ReceiverValue)callExtensionReceiver);
            }
            this.checkReceiverTypeError($receiver2, dispatchReceiver, $receiver2.candidateCall.getDispatchReceiver());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver, ReceiverParameterDescriptor receiverParameterDescriptor, ReceiverValue receiverArgument) {
        void $receiver$iv;
        void this_$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (((CandidateResolver)this_$iv).shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            void $receiver2;
            KotlinType erasedReceiverType;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = receiverParameterDescriptor == null || receiverArgument == null ? ResolutionStatus.SUCCESS : (!this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType = CallResolverUtilKt.getErasedReceiverType(receiverParameterDescriptor, this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2)), (ResolutionContext)$receiver2) ? ResolutionStatus.RECEIVER_TYPE_ERROR : ResolutionStatus.SUCCESS);
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceivers(CallCandidateResolutionContext<D> context) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall candidateCall = context.candidateCall;
        ResolvedCall resolvedCall = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall, "candidateCall");
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceiver(context, resolvedCall, candidateCall.getResultingDescriptor().getExtensionReceiverParameter(), (ReceiverValue)candidateCall.getExtensionReceiver(), candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(con\u2026xtensionReceiver, false))");
        resultStatus = resolutionStatus;
        ResolvedCall resolvedCall2 = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "candidateCall");
        ResolutionStatus resolutionStatus2 = resultStatus.combine(this.checkReceiver(context, resolvedCall2, candidateCall.getResultingDescriptor().getDispatchReceiverParameter(), candidateCall.getDispatchReceiver(), candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus2, "resultStatus.combine(con\u2026s CallForImplicitInvoke))");
        resultStatus = resolutionStatus2;
        return resultStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> ResolutionStatus checkReceiver(CallCandidateResolutionContext<D> $receiver, ResolvedCall<D> candidateCall, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        Object smartCastResult;
        void $receiver$iv;
        KtExpression expression;
        ReceiverValue receiverValue;
        Object outerReceiverDataFlowValue;
        Receiver outerCallReceiver;
        if (receiverParameter == null || receiverArgument == null) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), (Collection<TypeParameterDescriptor>)candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean isSubtypeBySmartCastIgnoringNullability = this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, receiverParameter.getType(), $receiver);
        if (!isSubtypeBySmartCastIgnoringNullability) {
            $receiver.tracing.wrongReceiverType($receiver.trace, receiverParameter, receiverArgument, (ResolutionContext<?>)$receiver.replaceCallPosition(new CallPosition.ExtensionReceiverPosition(candidateCall)));
            return ResolutionStatus.OTHER_ERROR;
        }
        Call call = candidateCall.getCall();
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && CallUtilKt.isExplicitSafeCall(call);
        KotlinType expectedReceiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameter.getType()) : receiverParameter.getType();
        boolean smartCastNeeded = !ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), expectedReceiverParameterType);
        boolean reportUnsafeCall = false;
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, $receiver);
        DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
        DataFlowValue dataFlowValue2 = dataFlowValue;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "dataFlowValue");
        Nullability nullability = dataFlowInfo.getPredictableNullability(dataFlowValue2);
        boolean nullableImplicitInvokeReceiver = false;
        KotlinType receiverArgumentType = receiverArgument.getType();
        if (implicitInvokeCheck && call instanceof CallTransformer.CallForImplicitInvoke && CallUtilKt.isSafeCall(call) && Intrinsics.areEqual(outerCallReceiver = ((CallTransformer.CallForImplicitInvoke)call).getOuterCall().getExplicitReceiver(), ((CallTransformer.CallForImplicitInvoke)call).getExplicitReceiver()) ^ true && outerCallReceiver instanceof ReceiverValue) {
            outerReceiverDataFlowValue = DataFlowValueFactory.createDataFlowValue((ReceiverValue)outerCallReceiver, $receiver);
            DataFlowInfo dataFlowInfo2 = $receiver.dataFlowInfo;
            Object object = outerReceiverDataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull(object, "outerReceiverDataFlowValue");
            Nullability outerReceiverNullability = dataFlowInfo2.getPredictableNullability((DataFlowValue)object);
            if (outerReceiverNullability.canBeNull() && !TypeUtils.isNullableType(expectedReceiverParameterType)) {
                nullableImplicitInvokeReceiver = true;
                receiverArgumentType = TypeUtils.makeNullable(receiverArgumentType);
            }
        }
        if (!((receiverValue = receiverArgument) instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        KtExpression ktExpression = expression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (nullability.canBeNull() && !nullability.canBeNonNull()) {
            if (!TypeUtils.isNullableType(expectedReceiverParameterType)) {
                reportUnsafeCall = true;
            }
            if (dataFlowValue.getImmanentNullability().canBeNonNull()) {
                Unit unit;
                KtExpression ktExpression2 = expression;
                if (ktExpression2 != null) {
                    outerReceiverDataFlowValue = ktExpression2;
                    KtExpression it = (KtExpression)$receiver$iv;
                    $receiver.trace.record(BindingContext.SMARTCAST_NULL, it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        } else if (!nullableImplicitInvokeReceiver && smartCastNeeded) {
            smartCastResult = SmartCastManager.checkAndRecordPossibleCast(dataFlowValue, expectedReceiverParameterType, expression, $receiver, candidateCall.getCall().getCalleeExpression(), true);
            if (smartCastResult == null) {
                reportUnsafeCall = true;
            } else if (!((SmartCastResult)smartCastResult).isCorrect()) {
                return ResolutionStatus.OTHER_ERROR;
            }
        }
        if (reportUnsafeCall || nullableImplicitInvokeReceiver) {
            $receiver.tracing.unsafeCall($receiver.trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        smartCastResult = this.additionalTypeCheckers;
        for (Object element$iv : $receiver$iv) {
            AdditionalTypeChecker it = (AdditionalTypeChecker)element$iv;
            it.checkReceiver(receiverParameter, receiverArgument, safeAccess, (CallResolutionContext)$receiver);
        }
        return ResolutionStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGenericBoundsInAFunctionCall(List<? extends KtTypeProjection> jetTypeArguments, List<? extends KotlinType> typeArguments, CallableDescriptor functionDescriptor, TypeSubstitutor substitutor2, BindingTrace trace) {
        int n = 0;
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        int n2 = Math.min(typeParameters.size(), jetTypeArguments.size()) - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = typeParameters.get((int)i);
                KotlinType typeArgument = typeArguments.get((int)i);
                KtTypeReference typeReference = jetTypeArguments.get((int)i).getTypeReference();
                if (typeReference != null) {
                    DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor2, trace);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final <D extends CallableDescriptor> boolean shouldContinue(CallCandidateResolutionContext<D> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.candidateResolveMode, (Object)CandidateResolveMode.FULLY) || $receiver.candidateCall.getStatus().possibleTransformToSuccess();
    }

    private final CallableDescriptor getCandidateDescriptor(CallCandidateResolutionContext<?> $receiver) {
        Object d = $receiver.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.getCandidateDescriptor()");
        return d;
    }

    public CandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull GenericCandidateResolver genericCandidateResolver, @NotNull ReflectionTypes reflectionTypes, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(genericCandidateResolver, "genericCandidateResolver");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.argumentTypeResolver = argumentTypeResolver;
        this.genericCandidateResolver = genericCandidateResolver;
        this.reflectionTypes = reflectionTypes;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.smartCastManager = smartCastManager;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "", "status", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "argumentTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;Ljava/util/List;)V", "getArgumentTypes", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "kotlin-compiler"})
    public final class ValueArgumentsCheckingResult {
        @NotNull
        private final ResolutionStatus status;
        @NotNull
        private final List<KotlinType> argumentTypes;

        @NotNull
        public final ResolutionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final List<KotlinType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public ValueArgumentsCheckingResult(@NotNull ResolutionStatus status2, @NotNull List<? extends KotlinType> argumentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)status2, "status");
            Intrinsics.checkParameterIsNotNull(argumentTypes, "argumentTypes");
            this.status = status2;
            this.argumentTypes = argumentTypes;
        }
    }
}

