/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.picocontainer.defaults;

import org.jetbrains.kotlin.relocated.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.relocated.org.picocontainer.monitors.DefaultComponentMonitor;

public class InstanceComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    private Object componentInstance;
    private LifecycleStrategy lifecycleStrategy;

    public InstanceComponentAdapter(Object componentKey, Object componentInstance) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentInstance, new DefaultLifecycleStrategy(new DefaultComponentMonitor()));
    }

    public InstanceComponentAdapter(Object componentKey, Object componentInstance, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, InstanceComponentAdapter.getInstanceClass(componentInstance));
        this.componentInstance = componentInstance;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    private static Class getInstanceClass(Object componentInstance) {
        if (componentInstance == null) {
            throw new NullPointerException("componentInstance cannot be null");
        }
        return componentInstance.getClass();
    }

    @Override
    public Object getComponentInstance(PicoContainer container) {
        return this.componentInstance;
    }
}

