/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"name", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "getName", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "setInlineCallMetadata", "", "expression", "psiElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "aliasedName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin-compiler"})
@JvmName(name="InlineUtils")
public final class InlineUtils {
    /*
     * WARNING - void declaration
     */
    public static final void setInlineCallMetadata(@NotNull JsExpression expression, @NotNull KtExpression psiElement, @NotNull ResolvedCall<?> resolvedCall, @NotNull TranslationContext context) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(psiElement, "psiElement");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor descriptor2 = PsiUtils.getFunctionDescriptor(resolvedCall);
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor2);
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Expected descriptor of callable, that should be inlined, but got: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        CallableDescriptor callableDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
        JsName name = InlineUtils.aliasedName(context, callableDescriptor);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(name, descriptor2, psiElement){
            final /* synthetic */ JsName $name;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ KtExpression $psiElement;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull(invocation, "invocation");
                super.visitInvocation(invocation);
                if (Intrinsics.areEqual(this.$name, InlineUtils.getName(invocation))) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInlineStrategy(invocation, InlineStrategy.IN_PLACE);
                    MetadataProperties.setPsiElement(invocation, this.$psiElement);
                }
            }
            {
                this.$name = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
                this.$psiElement = $captured_local_variable$2;
            }
        };
        visitor2.accept((JsNode)expression);
    }

    @NotNull
    public static final JsName aliasedName(TranslationContext $receiver, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JsExpression alias = $receiver.getAliasForDescriptor(descriptor2);
        JsExpression jsExpression = alias;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        JsName aliasName = jsNameRef != null ? jsNameRef.getName() : null;
        JsName jsName = aliasName;
        if (jsName == null) {
            JsName jsName2 = $receiver.getNameForDescriptor(descriptor2);
            jsName = jsName2;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "getNameForDescriptor(descriptor)");
        }
        return jsName;
    }

    @Nullable
    public static final JsName getName(JsExpression $receiver) {
        JsName jsName;
        JsExpression jsExpression = $receiver;
        if (jsExpression instanceof JsInvocation) {
            JsExpression qualifier2 = ((JsInvocation)$receiver).getQualifier();
            if (InvocationUtilsKt.isCallInvocation((JsInvocation)$receiver)) {
                JsExpression jsExpression2 = qualifier2;
                if (jsExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
                }
                jsName = InlineUtils.getName(((JsNameRef)jsExpression2).getQualifier());
            } else {
                jsName = InlineUtils.getName(qualifier2);
            }
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$receiver).getName() : (JsName)null;
        }
        return jsName;
    }
}

