/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.intrinsics.TypeIntrinsics;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\"\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015\u00a8\u0006\u0018"}, d2={"generateAsCast", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isSafe", "", "generateIsCheck", "generateNullCheckForNonSafeAs", "type", "populateCompanionBackingFieldNamesToOuterContextIfNeeded", "companion", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "outerContext", "Lorg/jetbrains/kotlin/codegen/context/FieldOwnerContext;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "replaceValueParametersIn", "", "Lorg/jetbrains/kotlin/load/java/BuiltinMethodsWithSpecialGenericSignature$SpecialSignatureInfo;", "sourceSignature", "kotlin-compiler"})
public final class CodegenUtilKt {
    public static final void generateIsCheck(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type asmType) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(asmType, "asmType");
        if (TypeUtils.isNullableType(kotlinType)) {
            Label nope = new Label();
            Label end = new Label();
            InstructionAdapter $receiver = v;
            $receiver.dup();
            $receiver.ifnull(nope);
            TypeIntrinsics.instanceOf($receiver, kotlinType, asmType);
            $receiver.goTo(end);
            $receiver.mark(nope);
            $receiver.pop();
            $receiver.iconst(1);
            $receiver.mark(end);
        } else {
            TypeIntrinsics.instanceOf(v, kotlinType, asmType);
        }
    }

    public static final void generateAsCast(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type asmType, boolean isSafe) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(asmType, "asmType");
        if (!isSafe) {
            if (!TypeUtils.isNullableType(kotlinType)) {
                CodegenUtilKt.generateNullCheckForNonSafeAs(v, kotlinType);
            }
        } else {
            InstructionAdapter $receiver = v;
            $receiver.dup();
            TypeIntrinsics.instanceOf(v, kotlinType, asmType);
            Label ok = new Label();
            $receiver.ifne(ok);
            $receiver.pop();
            $receiver.aconst(null);
            $receiver.mark(ok);
        }
        TypeIntrinsics.checkcast(v, kotlinType, asmType, isSafe);
    }

    private static final void generateNullCheckForNonSafeAs(InstructionAdapter v, KotlinType type2) {
        InstructionAdapter $receiver = v;
        $receiver.dup();
        Label nonnull = new Label();
        $receiver.ifnonnull(nonnull);
        AsmUtil.genThrow(v, "kotlin/TypeCastException", "null cannot be cast to non-null type " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2));
        $receiver.mark(nonnull);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String replaceValueParametersIn(BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo $receiver, @Nullable String sourceSignature) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, "$receiver");
        String string2 = $receiver.getValueParametersSignature();
        if (string2 != null) {
            String string3;
            String $receiver$iv = string2;
            String it = $receiver$iv;
            String string4 = sourceSignature;
            if (string4 != null) {
                void replacement$iv;
                void $receiver$iv2;
                void regex$iv;
                Regex $receiver$iv3;
                CharSequence charSequence = string4;
                String string5 = "^\\(.*\\)";
                $receiver$iv3 = new Regex((String)((Object)$receiver$iv3));
                String $i$f$toRegex = "(" + it + ")";
                string3 = regex$iv.replace((CharSequence)$receiver$iv2, (String)replacement$iv);
            } else {
                string3 = null;
            }
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void populateCompanionBackingFieldNamesToOuterContextIfNeeded(@NotNull KtObjectDeclaration companion, @NotNull FieldOwnerContext<?> outerContext, @NotNull GenerationState state2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(companion, "companion");
        Intrinsics.checkParameterIsNotNull(outerContext, "outerContext");
        Intrinsics.checkParameterIsNotNull(state2, "state");
        ClassDescriptor descriptor2 = (ClassDescriptor)state2.getBindingContext().get(BindingContext.CLASS, companion);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            return;
        }
        if (!JvmAbi.isCompanionObjectWithBackingFieldsInOuter(descriptor2)) {
            return;
        }
        Iterable iterable = companion.getDeclarations();
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properties2 = (List)destination$iv$iv;
        $receiver$iv = properties2;
        for (Object element$iv : $receiver$iv) {
            KtProperty it = (KtProperty)element$iv;
            VariableDescriptor variableDescriptor = (VariableDescriptor)state2.getBindingContext().get(BindingContext.VARIABLE, it);
            if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
            outerContext.getFieldName((PropertyDescriptor)variableDescriptor, it.hasDelegate());
        }
    }
}

