/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.OpenSSLSocketImpl;

public abstract class BaseOpenSSLSocketAdapterFactory
extends SSLSocketFactory {
    private final OpenSSLSocketFactoryImpl delegate;

    protected BaseOpenSSLSocketAdapterFactory(OpenSSLSocketFactoryImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket());
    }

    @Override
    public Socket createSocket(String hostname, int port) throws IOException, UnknownHostException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket(hostname, port));
    }

    @Override
    public Socket createSocket(String hostname, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket(hostname, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(Socket s, String hostname, int port, boolean autoClose) throws IOException {
        return this.wrap((OpenSSLSocketImpl)this.delegate.createSocket(s, hostname, port, autoClose));
    }

    protected abstract Socket wrap(OpenSSLSocketImpl var1) throws IOException;
}

