/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.util.Arrays;

public class FipsNonceGenerator {
    private final byte[] baseNonce;
    private final long counterMask;
    private final int counterBytes;
    private long counterValue;
    private boolean counterExhausted;

    public FipsNonceGenerator(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("'baseNonce' cannot be null");
        }
        if (byArray.length < 8) {
            throw new IllegalArgumentException("'baseNonce' must be at least 8 bytes");
        }
        if (n < 1 || n > 64) {
            throw new IllegalArgumentException("'counterBits' must be from 1 to 64 bits");
        }
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (byArray.length < 12) {
                throw new IllegalArgumentException("Approved mode requires 'baseNonce' of at least 12 bytes");
            }
            if (n < 32) {
                throw new IllegalArgumentException("Approved mode requires 'counterBits' of at least 32 bits");
            }
        }
        this.baseNonce = Arrays.clone(byArray);
        this.counterMask = -1L >>> 64 - n;
        this.counterBytes = (n + 7) / 8;
        this.counterValue = 0L;
        this.counterExhausted = false;
    }

    public void generateNonce(byte[] byArray) {
        if (this.baseNonce.length != byArray.length) {
            throw new IllegalArgumentException("'nonce' length must match the base nonce length (" + this.baseNonce.length + " bytes)");
        }
        if (this.counterExhausted) {
            throw new IllegalStateException("TLS nonce generator exhausted");
        }
        System.arraycopy(this.baseNonce, 0, byArray, 0, this.baseNonce.length);
        this.xorCounter(byArray, this.baseNonce.length - this.counterBytes);
        this.counterExhausted |= (++this.counterValue & this.counterMask) == 0L;
    }

    private void xorCounter(byte[] byArray, int n) {
        for (int i = 0; i < this.counterBytes; ++i) {
            int n2 = n + i;
            byArray[n2] = (byte)(byArray[n2] ^ (byte)(this.counterValue >>> (this.counterBytes - 1 - i) * 8));
        }
    }
}

