/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import java.util.function.Function;
import org.apache.tuweni.units.bigints.UInt384;
import org.apache.tuweni.units.bigints.UInt384Value;

public final class UInt384ValueDomain<T extends UInt384Value<T>>
extends DiscreteDomain<T> {
    private final T minValue;
    private final T maxValue;

    public UInt384ValueDomain(Function<UInt384, T> ctor) {
        this.minValue = (UInt384Value)ctor.apply(UInt384.MIN_VALUE);
        this.maxValue = (UInt384Value)ctor.apply(UInt384.MAX_VALUE);
    }

    public T next(T value) {
        return value.add(1L);
    }

    public T previous(T value) {
        return value.subtract(1L);
    }

    public long distance(T start, T end) {
        T distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        T t = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public T minValue() {
        return this.minValue;
    }

    public T maxValue() {
        return this.maxValue;
    }
}

