/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import org.apache.tuweni.units.bigints.UInt32;

public final class UInt32Domain
extends DiscreteDomain<UInt32> {
    public UInt32 next(UInt32 value) {
        return value.add(1);
    }

    public UInt32 previous(UInt32 value) {
        return value.subtract(1);
    }

    public long distance(UInt32 start, UInt32 end) {
        UInt32 distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        UInt32 uInt32 = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public UInt32 minValue() {
        return UInt32.MIN_VALUE;
    }

    public UInt32 maxValue() {
        return UInt32.MAX_VALUE;
    }
}

