/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io.file;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.tuweni.io.IOConsumer;

public final class Files {
    private Files() {
    }

    public static boolean createFileIfMissing(Path path, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(path);
        try {
            java.nio.file.Files.createFile(path, attrs);
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        return true;
    }

    public static void deleteRecursively(Path directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        java.nio.file.Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    java.nio.file.Files.delete(file);
                }
                catch (IOException ioe) {
                    file.toFile().deleteOnExit();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    java.nio.file.Files.delete(dir);
                }
                catch (IOException ioe) {
                    dir.toFile().deleteOnExit();
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static Path copyResource(String resourceName, Path destination, OpenOption ... options) throws IOException {
        return Files.copyResource(Files.class.getClassLoader(), resourceName, destination, options);
    }

    public static Path copyResource(ClassLoader classloader, String resourceName, Path destination, OpenOption ... options) throws IOException {
        Objects.requireNonNull(resourceName);
        Objects.requireNonNull(destination);
        try (OutputStream out = java.nio.file.Files.newOutputStream(destination, options);){
            Files.copyResource(classloader, resourceName, out);
        }
        return destination;
    }

    public static long copyResource(String resourceName, OutputStream out) throws IOException {
        return Files.copyResource(Files.class.getClassLoader(), resourceName, out);
    }

    public static long copyResource(ClassLoader classloader, String resourceName, OutputStream out) throws IOException {
        try (InputStream in = classloader.getResourceAsStream(resourceName);){
            int n;
            if (in == null) {
                throw new IllegalArgumentException(resourceName + " could not be accessed");
            }
            long total = 0L;
            byte[] buf = new byte[4096];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
                total += (long)n;
            }
            long l = total;
            return l;
        }
    }

    public static void atomicReplace(Path path, byte[] bytes) throws IOException {
        Objects.requireNonNull(bytes);
        Path directory = path.getParent();
        java.nio.file.Files.createDirectories(directory, new FileAttribute[0]);
        Path tempFile = java.nio.file.Files.createTempFile(directory, "." + path.getName(0), ".tmp", new FileAttribute[0]);
        try {
            java.nio.file.Files.write(tempFile, bytes, new OpenOption[0]);
            java.nio.file.Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable e) {
            try {
                java.nio.file.Files.delete(tempFile);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public static void atomicReplace(Path path, IOConsumer<Writer> fn) throws IOException {
        Files.atomicReplace(path, StandardCharsets.UTF_8, fn);
    }

    public static void atomicReplace(Path path, Charset charset, IOConsumer<Writer> fn) throws IOException {
        Objects.requireNonNull(charset);
        Objects.requireNonNull(fn);
        Path directory = path.getParent();
        java.nio.file.Files.createDirectories(directory, new FileAttribute[0]);
        Path tempFile = java.nio.file.Files.createTempFile(directory, "." + path.getName(0), ".tmp", new FileAttribute[0]);
        BufferedWriter writer = null;
        try {
            writer = java.nio.file.Files.newBufferedWriter(tempFile, charset, new OpenOption[0]);
            fn.accept(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            java.nio.file.Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable e) {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
            }
            try {
                java.nio.file.Files.delete(tempFile);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }
}

