/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import com.google.common.base.Preconditions;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.apache.tuweni.crypto.sodium.SodiumException;

public final class Auth {
    private Auth() {
    }

    public static Bytes auth(Bytes input, Key key) {
        return Bytes.wrap((byte[])Auth.auth(input.toArrayUnsafe(), key));
    }

    public static byte[] auth(byte[] input, Key key) {
        Preconditions.checkArgument((!key.isDestroyed() ? 1 : 0) != 0, (Object)"Key has been destroyed");
        long abytes = Sodium.crypto_auth_bytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_auth_bytes: " + abytes + " is too large");
        }
        byte[] tag = new byte[(int)abytes];
        int rc = Sodium.crypto_auth(tag, input, input.length, key.value.pointer());
        if (rc != 0) {
            throw new SodiumException("crypto_auth_bytes: failed with result " + rc);
        }
        return tag;
    }

    public static boolean verify(Bytes tag, Bytes input, Key key) {
        return Auth.verify(tag.toArrayUnsafe(), input.toArrayUnsafe(), key);
    }

    public static boolean verify(byte[] tag, byte[] input, Key key) {
        Preconditions.checkArgument((!key.isDestroyed() ? 1 : 0) != 0, (Object)"Key has been destroyed");
        long abytes = Sodium.crypto_auth_bytes();
        if ((long)tag.length != abytes) {
            throw new IllegalArgumentException("tag must be " + abytes + " bytes, got " + tag.length);
        }
        int rc = Sodium.crypto_auth_verify(tag, input, input.length, key.value.pointer());
        return rc == 0;
    }

    public static final class Key
    implements Destroyable {
        final Allocated value;

        private Key(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public static Key fromBytes(Bytes bytes) {
            return Key.fromBytes(bytes.toArrayUnsafe());
        }

        public static Key fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_auth_keybytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_auth_keybytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Key::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_auth_keybytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_auth_keybytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public static Key random() {
            int length = Key.length();
            Pointer ptr = Sodium.malloc(length);
            try {
                Sodium.randombytes_buf(ptr, length);
                return new Key(ptr, length);
            }
            catch (Throwable e) {
                Sodium.sodium_free(ptr);
                throw e;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }
}

