/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import org.apache.milagro.amcl.BLS381.BIG;
import org.apache.milagro.amcl.BLS381.ECP;
import org.apache.milagro.amcl.BLS381.ROM;
import org.apache.milagro.amcl.RAND;
import org.apache.tuweni.crypto.mikuli.G1Point;
import org.apache.tuweni.crypto.mikuli.PublicKey;
import org.apache.tuweni.crypto.mikuli.Scalar;
import org.apache.tuweni.crypto.mikuli.SecretKey;

public final class KeyPair {
    private static final BIG curveOrder = new BIG(ROM.CURVE_Order);
    static final G1Point g1Generator = new G1Point(ECP.generator());
    private final SecretKey secretKey;
    private final PublicKey publicKey;

    public static KeyPair random() {
        RAND rng = new RAND();
        Scalar secret = new Scalar(BIG.randomnum((BIG)curveOrder, (RAND)rng));
        SecretKey secretKey = new SecretKey(secret);
        G1Point g1Point = g1Generator.mul(secret);
        PublicKey publicKey = new PublicKey(g1Point);
        return new KeyPair(secretKey, publicKey);
    }

    private KeyPair(SecretKey secretKey, PublicKey publicKey) {
        this.secretKey = secretKey;
        this.publicKey = publicKey;
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }
}

