/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.Objects;
import org.apache.milagro.amcl.BLS381.ECP;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.Group;
import org.apache.tuweni.crypto.mikuli.Scalar;

final class G1Point
implements Group<G1Point> {
    private static final int fpPointSize = 48;
    private final ECP point;

    static G1Point fromBytes(Bytes bytes) {
        return new G1Point(ECP.fromBytes((byte[])bytes.toArrayUnsafe()));
    }

    G1Point(ECP point) {
        this.point = point;
    }

    @Override
    public G1Point add(G1Point other) {
        ECP sum = new ECP();
        sum.add(this.point);
        sum.add(other.point);
        sum.affine();
        return new G1Point(sum);
    }

    @Override
    public G1Point mul(Scalar scalar) {
        ECP newPoint = this.point.mul(scalar.value());
        return new G1Point(newPoint);
    }

    Bytes toBytes() {
        byte[] bytes = new byte[49];
        this.point.toBytes(bytes, true);
        return Bytes.wrap((byte[])bytes);
    }

    ECP ecpPoint() {
        return this.point;
    }

    public String toString() {
        return this.point.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long x = this.point.getX().norm();
        long y = this.point.getY().norm();
        result = 31 * result + (int)(x ^ x >>> 32);
        result = 31 * result + (int)(y ^ y >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof G1Point)) {
            return false;
        }
        G1Point other = (G1Point)obj;
        return this.point.equals(other.point);
    }
}

