/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.List;
import org.apache.tuweni.crypto.mikuli.PublicKey;
import org.apache.tuweni.crypto.mikuli.Signature;

public final class SignatureAndPublicKey {
    private final Signature signature;
    private final PublicKey publicKey;

    public static SignatureAndPublicKey aggregate(List<SignatureAndPublicKey> sigAndPubKeys) {
        if (sigAndPubKeys.isEmpty()) {
            throw new IllegalArgumentException("Parameter list is empty");
        }
        return (SignatureAndPublicKey)sigAndPubKeys.stream().reduce((a, b) -> a.combine((SignatureAndPublicKey)b)).get();
    }

    SignatureAndPublicKey(Signature signature, PublicKey pubKey) {
        this.signature = signature;
        this.publicKey = pubKey;
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public Signature signature() {
        return this.signature;
    }

    public SignatureAndPublicKey combine(SignatureAndPublicKey sigAndPubKey) {
        Signature newSignature = this.signature.combine(sigAndPubKey.signature);
        PublicKey newPubKey = this.publicKey.combine(sigAndPubKey.publicKey);
        return new SignatureAndPublicKey(newSignature, newPubKey);
    }
}

