/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import org.apache.milagro.amcl.BLS381.ECP2;
import org.apache.milagro.amcl.BLS381.MPIN;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.AtePairing;
import org.apache.tuweni.crypto.mikuli.G1Point;
import org.apache.tuweni.crypto.mikuli.G2Point;
import org.apache.tuweni.crypto.mikuli.GTPoint;
import org.apache.tuweni.crypto.mikuli.KeyPair;
import org.apache.tuweni.crypto.mikuli.PublicKey;
import org.apache.tuweni.crypto.mikuli.Signature;
import org.apache.tuweni.crypto.mikuli.SignatureAndPublicKey;

public final class BLS12381 {
    private BLS12381() {
    }

    public static SignatureAndPublicKey sign(KeyPair keyPair, byte[] message, int domain) {
        G2Point hashInGroup2 = BLS12381.hashFunction(message, domain);
        G2Point sig = keyPair.secretKey().sign(hashInGroup2);
        return new SignatureAndPublicKey(new Signature(sig), keyPair.publicKey());
    }

    public static SignatureAndPublicKey sign(KeyPair keyPair, Bytes message, int domain) {
        return BLS12381.sign(keyPair, message.toArray(), domain);
    }

    public static boolean verify(PublicKey publicKey, Signature signature, byte[] message, int domain) {
        G1Point g1Generator = KeyPair.g1Generator;
        G2Point hashInGroup2 = BLS12381.hashFunction(message, domain);
        GTPoint e1 = AtePairing.pair(publicKey.g1Point(), hashInGroup2);
        GTPoint e2 = AtePairing.pair(g1Generator, signature.g2Point());
        return e1.equals(e2);
    }

    public static boolean verify(PublicKey publicKey, Signature signature, Bytes message, int domain) {
        return BLS12381.verify(publicKey, signature, message.toArray(), domain);
    }

    public static boolean verify(SignatureAndPublicKey sigAndPubKey, byte[] message, int domain) {
        return BLS12381.verify(sigAndPubKey.publicKey(), sigAndPubKey.signature(), message, domain);
    }

    public static boolean verify(SignatureAndPublicKey sigAndPubKey, Bytes message, int domain) {
        return BLS12381.verify(sigAndPubKey.publicKey(), sigAndPubKey.signature(), message, domain);
    }

    private static G2Point hashFunction(byte[] message, int domain) {
        byte[] hashByte = MPIN.HASH_ID((int)32, (byte[])message, (int)domain);
        return new G2Point(ECP2.mapit((byte[])hashByte));
    }
}

