/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.index.HiveIndexQueryContext;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.optimizer.physical.index.IndexWhereProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexWhereProcessor
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)IndexWhereProcessor.class.getName());
    private final Map<TableScanOperator, List<Index>> tsToIndices;

    public IndexWhereProcessor(Map<TableScanOperator, List<Index>> tsToIndices) {
        this.tsToIndices = tsToIndices;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        Set<Partition> queryPartitions;
        TableScanOperator operator = (TableScanOperator)nd;
        List opChildren = operator.getChildren();
        TableScanDesc operatorDesc = (TableScanDesc)operator.getConf();
        if (operatorDesc == null || !this.tsToIndices.containsKey(operator)) {
            return null;
        }
        List<Index> indexes = this.tsToIndices.get(operator);
        ExprNodeGenericFuncDesc predicate = operatorDesc.getFilterExpr();
        IndexWhereProcCtx context = (IndexWhereProcCtx)procCtx;
        ParseContext pctx = context.getParseContext();
        LOG.info("Processing predicate for index optimization");
        if (predicate == null) {
            LOG.info("null predicate pushed down");
            return null;
        }
        LOG.info(((ExprNodeDesc)predicate).getExprString());
        try {
            queryPartitions = IndexUtils.checkPartitionsCoveredByIndex(operator, pctx, indexes);
            if (queryPartitions == null) {
                return null;
            }
        }
        catch (HiveException e) {
            LOG.error("Fatal Error: problem accessing metastore", (Throwable)e);
            throw new SemanticException(e);
        }
        if (!context.getCurrentTask().isMapRedTask()) {
            return null;
        }
        MapRedTask currentTask = (MapRedTask)context.getCurrentTask();
        HashMap queryContexts = new HashMap();
        TableDesc tblDesc = operator.getTableDesc();
        HashMap indexesByType = new HashMap();
        for (Index index : indexes) {
            if (indexesByType.get(index.getIndexHandlerClass()) == null) {
                ArrayList<Index> newType = new ArrayList<Index>();
                newType.add(index);
                indexesByType.put(index.getIndexHandlerClass(), newType);
                continue;
            }
            ((List)indexesByType.get(index.getIndexHandlerClass())).add(index);
        }
        List bestIndexes = (List)indexesByType.values().iterator().next();
        for (List indexTypes : indexesByType.values()) {
            if (bestIndexes.size() >= indexTypes.size()) continue;
            bestIndexes = indexTypes;
        }
        HiveIndexQueryContext hiveIndexQueryContext = new HiveIndexQueryContext();
        hiveIndexQueryContext.setQueryPartitions(queryPartitions);
        this.rewriteForIndexes(predicate, bestIndexes, pctx, currentTask, hiveIndexQueryContext);
        List<Task<? extends Serializable>> indexTasks = hiveIndexQueryContext.getQueryTasks();
        if (indexTasks != null && indexTasks.size() > 0) {
            queryContexts.put(bestIndexes.get(0), hiveIndexQueryContext);
        }
        if (queryContexts.size() > 0) {
            Index chosenIndex = (Index)queryContexts.keySet().iterator().next();
            HiveIndexQueryContext queryContext = (HiveIndexQueryContext)queryContexts.get(chosenIndex);
            MapWork work = ((MapredWork)currentTask.getWork()).getMapWork();
            work.setInputformat(queryContext.getIndexInputFormat());
            work.addIndexIntermediateFile(queryContext.getIndexIntermediateFile());
            HashSet<ReadEntity> inputs = pctx.getSemanticInputs();
            inputs.addAll(queryContext.getAdditionalSemanticInputs());
            List<Task<?>> chosenRewrite = queryContext.getQueryTasks();
            this.insertIndexQuery(pctx, context, chosenRewrite);
        }
        return null;
    }

    private void rewriteForIndexes(ExprNodeDesc predicate, List<Index> indexes, ParseContext pctx, Task<MapredWork> task, HiveIndexQueryContext queryContext) throws SemanticException {
        HiveIndexHandler indexHandler;
        Index index = indexes.get(0);
        try {
            indexHandler = HiveUtils.getIndexHandler(pctx.getConf(), index.getIndexHandlerClass());
        }
        catch (HiveException e) {
            LOG.error("Exception while loading IndexHandler: " + index.getIndexHandlerClass(), (Throwable)e);
            throw new SemanticException("Failed to load indexHandler: " + index.getIndexHandlerClass(), e);
        }
        try {
            ContentSummary inputSummary = Utilities.getInputSummary(pctx.getContext(), task.getWork().getMapWork(), null);
            long inputSize = inputSummary.getLength();
            if (!indexHandler.checkQuerySize(inputSize, pctx.getConf())) {
                queryContext.setQueryTasks(null);
                return;
            }
        }
        catch (IOException e) {
            throw new SemanticException("Failed to get task size", e);
        }
        indexHandler.generateIndexQuery(indexes, predicate, pctx, queryContext);
    }

    private void insertIndexQuery(ParseContext pctx, IndexWhereProcCtx context, List<Task<?>> chosenRewrite) {
        Task<? extends Serializable> wholeTableScan = context.getCurrentTask();
        LinkedHashSet rewriteLeaves = new LinkedHashSet();
        this.findLeaves(chosenRewrite, rewriteLeaves);
        for (Task task : rewriteLeaves) {
            task.addDependentTask(wholeTableScan);
        }
        pctx.replaceRootTask(wholeTableScan, chosenRewrite);
    }

    private void findLeaves(List<Task<?>> tasks, Set<Task<?>> leaves) {
        for (Task<?> t : tasks) {
            if (t.getDependentTasks() == null) {
                leaves.add(t);
                continue;
            }
            this.findLeaves(t.getDependentTasks(), leaves);
        }
    }
}

