/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class Nexus
extends WeakReference<ClassLoader> {
    protected static final ReferenceQueue<ClassLoader> NO_QUEUE = null;
    private static final ConcurrentMap<Nexus, Object> TYPE_INITIALIZERS = new ConcurrentHashMap<Nexus, Object>();
    private final String name;
    private final int classLoaderHashCode;
    private final int identification;

    private Nexus(Class<?> type, int identification) {
        this(Nexus.nonAnonymous(type.getName()), type.getClassLoader(), NO_QUEUE, identification);
    }

    private Nexus(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification) {
        super(classLoader, classLoader == null ? null : referenceQueue);
        this.name = name;
        this.classLoaderHashCode = System.identityHashCode(classLoader);
        this.identification = identification;
    }

    private static String nonAnonymous(String typeName) {
        int anonymousLoaderIndex = typeName.indexOf(47);
        return anonymousLoaderIndex == -1 ? typeName : typeName.substring(0, anonymousLoaderIndex);
    }

    public static void initialize(Class<?> type, int identification) throws Exception {
        Object typeInitializer = TYPE_INITIALIZERS.remove(new Nexus(type, identification));
        if (typeInitializer != null) {
            typeInitializer.getClass().getMethod("onLoad", Class.class).invoke(typeInitializer, type);
        }
    }

    public static void register(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification, Object typeInitializer) {
        if (TYPE_INITIALIZERS.put(new Nexus(name, classLoader, referenceQueue, identification), typeInitializer) != null) {
            Logger.getLogger("net.bytebuddy").warning("Initializer with id " + identification + " is already registered for " + name);
        }
    }

    public static void clean(Reference<? super ClassLoader> reference) {
        TYPE_INITIALIZERS.remove(reference);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Nexus nexus = (Nexus)object;
        return this.classLoaderHashCode == nexus.classLoaderHashCode && this.identification == nexus.identification && this.get() == nexus.get() && this.name.equals(nexus.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.identification;
        result = 31 * result + this.classLoaderHashCode;
        return result;
    }

    public String toString() {
        return "Nexus{name='" + this.name + '\'' + ", classLoaderReference=" + this.get() + ", classLoaderHashCode=" + this.classLoaderHashCode + ", identification=" + this.identification + '}';
    }
}

