/*
 * Decompiled with CFR 0.152.
 */
package id.zelory.compressor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ImageUtil {
    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File compressImage(File imageFile, int reqWidth, int reqHeight, Bitmap.CompressFormat compressFormat, int quality, String destinationPath) throws IOException {
        FileOutputStream fileOutputStream = null;
        File file = new File(destinationPath).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(destinationPath);
            ImageUtil.decodeSampledBitmapFromFile(imageFile, reqWidth, reqHeight).compress(compressFormat, quality, (OutputStream)fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        return new File(destinationPath);
    }

    static Bitmap decodeSampledBitmapFromFile(File imageFile, int reqWidth, int reqHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap scaledBitmap = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
        int orientation = exif.getAttributeInt("Orientation", 0);
        Matrix matrix = new Matrix();
        if (orientation == 6) {
            matrix.postRotate(90.0f);
        } else if (orientation == 3) {
            matrix.postRotate(180.0f);
        } else if (orientation == 8) {
            matrix.postRotate(270.0f);
        }
        scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return scaledBitmap;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

