/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class CollectionUtils {
    public static <T> void iterate(Collection<T> collection, Visitor<T> visitor) {
        for (T element : collection) {
            visitor.onVisit(element);
        }
    }

    public static <T> boolean isExists(Collection<T> collection, T object) {
        for (T element : collection) {
            if (element.hashCode() != object.hashCode()) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(Collection<T> collection, T object) {
        AtomicInteger index = new AtomicInteger(0);
        for (T element : collection) {
            if (element.hashCode() == object.hashCode()) {
                return index.get();
            }
            index.incrementAndGet();
        }
        return -1;
    }

    public static <T> Set<T> depCopy(Set<T> srcList) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(srcList);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream inStream = new ObjectInputStream(byteIn);
            Set destList = (Set)inStream.readObject();
            return destList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static interface Visitor<T> {
        public void onVisit(T var1);
    }
}

