/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.medialib.video.MediaVideoMsg;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AudioInfo;
import com.yy.yylivekit.model.BuzInfo;
import com.yy.yylivekit.model.HardwareEncodeBlacklist;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.model.MixVideoLayout;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yy.yylivekit.model.VideoQuality;
import com.yy.yylivekit.utils.VideoQualityCalc;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final String TAG = "JsonUtils";

    public static Map<String, Object> parsePublishEncodeConfig(String jsonString, HardwareEncodeBlacklist hardwareEncodeBlacklist) {
        if (FP.empty((CharSequence)jsonString)) {
            YLKLog.e(TAG, "HardwareEncodeBlacklist null params");
            jsonString = "{\"anchor\":{\n    \"entEncode\":1,\n    \"bframeswitch\": 0,\n    \"resolutionModifyInterval\":10,\n    \"resolution2\":[\n        {\n            \"key\":1,\n            \"width\":368,\n            \"height\":640,\n            \"codeRate\":800,\n            \"currate\":800,\n            \"frameRate\":24,\n            \"isDefault\":0,\n            \"meiyan\":\"\",\n            \"encode_id\":200,\n            \"param\":\"\",\n            \"modifyConfig\":[\n                {\n                    \"width\":368,\n                    \"height\":640,\n                    \"minCodeRate\":200,\n                    \"maxCodeRate\":800,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                }\n            ]\n        },\n        {\n            \"key\":2,\n            \"width\":544,\n            \"height\":960,\n            \"codeRate\":1200,\n            \"currate\":1200,\n            \"frameRate\":24,\n            \"isDefault\":1,\n            \"meiyan\":\"\",\n            \"encode_id\":200,\n            \"param\":\"\",\n            \"modifyConfig\":[\n                {\n                    \"width\":368,\n                    \"height\":640,\n                    \"minCodeRate\":200,\n                    \"maxCodeRate\":1000,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                },\n                {\n                    \"width\":544,\n                    \"height\":960,\n                    \"minCodeRate\":600,\n                    \"maxCodeRate\":1200,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                }\n            ]\n        }\n    ]\n}}";
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            JSONObject anchorObj = jsonObject.optJSONObject("anchor");
            int modifyInterval = anchorObj.optInt("resolutionModifyInterval");
            JSONArray resolution = anchorObj.optJSONArray("resolution2");
            Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap = JsonUtils.configsFromJsonArray(resolution, hardwareEncodeBlacklist);
            configMap.put("modifyInterval", modifyInterval);
            configMap.put("encodeMetaMap", encodeMetaMap);
        }
        catch (Exception e) {
            YLKLog.e(TAG, "parseEncodeMeta failed!" + Log.getStackTraceString((Throwable)e));
        }
        return configMap;
    }

    public static HardwareEncodeBlacklist parseHardwareEncodeBlacklist(String jsonString) {
        if (FP.empty((CharSequence)jsonString)) {
            YLKLog.e(TAG, "HardwareEncodeBlacklist null params");
            jsonString = "{\"anchor\":{\"blackCodec\":[\"OMX.IMG.TOPAZ.VIDEO.Encoder\"],\"blackModel\":[\"SM-N9006\",\"SM-N900\",\"Moto X Pro\",\"HM 2A\",\"Lenovo A938t\",\"HUAWEI P7-L09\",\"HUAWEI P7-L07\",\"L39u\",\"Lenovo A788t\",\"Coolpad 8720L\",\"Coolpad 8705\",\"vivo X5Pro D\",\"SCL-CL00\",\"GT-I9300\",\"HS-X8T\",\"vivo V3M A\",\"vivo X5L\"]}}";
        }
        HashSet<String> encoders = new HashSet<String>();
        HashSet<String> models = new HashSet<String>();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            JSONObject anchorObj = jsonObject.optJSONObject("anchor");
            JSONArray blackCodec = anchorObj.optJSONArray("blackCodec");
            for (int i = 0; i < blackCodec.length(); ++i) {
                String encoder = blackCodec.optString(i);
                encoders.add(encoder);
            }
            JSONArray blackModel = anchorObj.optJSONArray("blackModel");
            for (int i = 0; i < blackModel.length(); ++i) {
                String model = blackModel.optString(i);
                models.add(model);
            }
        }
        catch (JSONException e) {
            YLKLog.e(TAG, "parseHardwareEncodeBlacklist failed!" + Log.getStackTraceString((Throwable)e));
        }
        return new HardwareEncodeBlacklist(encoders, models);
    }

    private static Map<Integer, LiveMeta.EncodeMeta> configsFromJsonArray(JSONArray jsonArray, HardwareEncodeBlacklist blacklist) {
        try {
            HashMap<Integer, LiveMeta.EncodeMeta> configs = new HashMap<Integer, LiveMeta.EncodeMeta>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject item = jsonArray.optJSONObject(i);
                int key = item.optInt("key");
                int isDefault = item.optInt("isDefault", 0);
                int encodeId = item.optInt("encode_id", 200);
                encodeId = JsonUtils.adjustedEncodeId(encodeId, blacklist);
                String encodeParam = item.optString("encode_param", "");
                if (encodeParam.equals("default") && !Env.instance().isHardwareEncoderType(encodeId)) {
                    encodeParam = "";
                }
                configs.put(key, new LiveMeta.EncodeMeta(isDefault, key, item.optInt("width"), item.optInt("height"), item.optInt("codeRate"), item.optInt("currate", -1), item.optInt("minrate", -1), item.optInt("maxrate", -1), item.optInt("frameRate"), encodeId, encodeParam, item.optInt("previewWidth", -1), item.optInt("previewHeight", -1), item.optInt("previewFrameRate", -1), JsonUtils.modifyConfigFromJsonArray(item.optJSONArray("modifyConfig"))));
            }
            YLKLog.i("YLK", " configsFromJsonArray configs = [" + configs + "]");
            return configs;
        }
        catch (Exception e) {
            YLKLog.e("YLK", " configsFromJsonArray Exception: " + e);
            return null;
        }
    }

    private static int adjustedEncodeId(int raw, HardwareEncodeBlacklist blacklist) {
        if (blacklist.contains(Build.MODEL) || blacklist.contains(YYVideoCodec.getH264EncodeName()) || blacklist.contains(YYVideoCodec.getH265EncodeName())) {
            if (raw == 200) {
                return 201;
            }
            if (raw == 220) {
                return 221;
            }
        }
        return raw;
    }

    private static List<LiveMeta.ModifyMeta> modifyConfigFromJsonArray(JSONArray jsonArray) {
        try {
            ArrayList<LiveMeta.ModifyMeta> configs = new ArrayList<LiveMeta.ModifyMeta>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject item = jsonArray.optJSONObject(i);
                configs.add(new LiveMeta.ModifyMeta(item.optInt("width", 0), item.optInt("height", 0), item.optInt("minCodeRate", 0), item.optInt("maxCodeRate", 0), item.optInt("minFrameRate", 0), item.optInt("maxFrameRate", 0), item.optInt("encode_id", 0), item.optString("encode_param", "")));
            }
            return configs;
        }
        catch (Exception e) {
            YLKLog.e("YLK", " modifyConfigFromJsonArray Exception: " + e);
            return new ArrayList<LiveMeta.ModifyMeta>();
        }
    }

    public static boolean validateJsonObject(JsonElement element, String[] requisiteElements) {
        if (!element.isJsonObject()) {
            return false;
        }
        JsonObject obj = element.getAsJsonObject();
        for (String name : requisiteElements) {
            if (obj.has(name)) continue;
            return false;
        }
        return true;
    }

    public static MixVideoLayout createLayoutParams(SparseArray<Long> mic2Uid) {
        ArrayList<MixVideoLayout.Params> layoutParams = new ArrayList<MixVideoLayout.Params>();
        for (int i = 0; i < mic2Uid.size(); ++i) {
            int mic = mic2Uid.keyAt(i);
            long uid = (Long)mic2Uid.get(mic);
            layoutParams.add(new MixVideoLayout.Params(0, 0, 0, 0, mic, uid));
        }
        return new MixVideoLayout(MixVideoLayout.Style.NA, layoutParams);
    }

    public static List<Integer> parseCodeRateRange(JSONObject jsonObj) {
        String[] rateLevelName = new String[]{"standard", "high", "super"};
        ArrayList<Integer> codeRange = new ArrayList<Integer>();
        for (String name : rateLevelName) {
            codeRange.add(jsonObj.optInt(name));
        }
        return codeRange;
    }

    public static LiveInfo makeLiveInfo(String json) throws JSONException {
        Object layoutObj;
        JSONObject streamInfoObj = new JSONObject(json);
        if (streamInfoObj == null) {
            return null;
        }
        int appidElement = streamInfoObj.optInt("appid", 15013);
        String whRatioElement = streamInfoObj.optString("wh_ratio");
        JSONArray streamsElement = streamInfoObj.optJSONArray("stream");
        if (appidElement == -1 || FP.empty((CharSequence)whRatioElement) || streamsElement == null) {
            return null;
        }
        SparseArray mic2Uid = new SparseArray(2);
        JSONObject extendObj = streamInfoObj.optJSONObject("extend");
        if (extendObj != null && (layoutObj = extendObj.opt("layout")) != null) {
            JSONArray layoutArray = new JSONArray(layoutObj.toString());
            for (int i = 0; i < layoutArray.length(); ++i) {
                JSONObject paramObj = layoutArray.optJSONObject(i);
                if (paramObj == null) continue;
                int mic = paramObj.optInt("mic", 0);
                long uid = paramObj.optLong("uid", 0L);
                mic2Uid.put(mic, (Object)uid);
            }
        }
        ArrayList<StreamInfo> streamInfoList = new ArrayList<StreamInfo>();
        for (int index = 0; index < streamsElement.length(); ++index) {
            JSONObject streamObj = streamsElement.optJSONObject(index);
            int aEncoderType = streamObj.optInt("a_encoderType");
            int aRate = streamObj.optInt("a_rate");
            String aStreamName = streamObj.optString("a_stream_name");
            int vEncoderType = streamObj.optInt("v_encoderType");
            int vRate = streamObj.optInt("v_rate");
            String vStreamName = streamObj.optString("v_stream_name");
            int pair = streamObj.optInt("pair");
            JSONObject extend = streamObj.optJSONObject("extend");
            int source = 0;
            boolean isMs = false;
            VideoGearInfo videoGearInfo = null;
            if (extend != null) {
                JSONObject gearObj;
                String sourceVal = extend.optString("source");
                if (!FP.empty((CharSequence)sourceVal)) {
                    source = Integer.valueOf(sourceVal);
                    isMs = true;
                }
                if ((gearObj = new JSONObject(extend.optString("gearInfo"))) != null) {
                    int gear = gearObj.optInt("gear", -1);
                    String name = gearObj.optString("name", "");
                    int seq = gearObj.optInt("seq", -1);
                    if (gear != -1 || !FP.empty((CharSequence)name) || seq != -1) {
                        videoGearInfo = new VideoGearInfo(gear, name, seq, vRate);
                    }
                }
            }
            if (videoGearInfo == null) {
                VideoQuality quality = VideoQualityCalc.eval(vRate, vEncoderType != 100 ? 220 : 200);
                videoGearInfo = new VideoGearInfo(quality.ordinal() + 1, VideoQuality.description(quality), (quality.ordinal() + 1) * 100, vRate);
                YLKLog.i(TAG, "makeLiveInfo fake video gear=" + videoGearInfo);
            }
            AudioInfo audioInfo = new AudioInfo(appidElement, aStreamName, source, isMs, pair, true, JsonUtils.makeAudioConfig(pair, 0L, aRate, aEncoderType));
            String[] wh = whRatioElement.split(":");
            int with = Integer.valueOf(wh[0]);
            int height = Integer.valueOf(wh[1]);
            VideoInfo videoInfo = new VideoInfo(appidElement, vStreamName, source, isMs, with, height, vRate, vEncoderType, 0, pair, new BuzInfo(-1, -1), JsonUtils.createLayoutParams((SparseArray<Long>)mic2Uid), true, videoGearInfo, JsonUtils.makeVideoConfig(pair, 0L, vRate, vEncoderType, with, height), (Set<String>)new HashSet<String>(){
                {
                    this.add("mob");
                }
            });
            if (!Env.instance().getYlkMediaConfigs().isSupportH265Decode() && videoInfo.encode == 101) continue;
            streamInfoList.add(new StreamInfo(videoInfo, audioInfo, 2));
        }
        return new LiveInfo(0L, -1, 0, streamInfoList, true);
    }

    private static Map<Integer, Integer> makeAudioConfig(int pair, long uid, int rate, int encodeType) {
        return JsonUtils.makeConfig(pair, uid, MediaVideoMsg.LiveStreamType.STREAM_TYPE_AUDIO, rate, encodeType, 0, 0);
    }

    private static Map<Integer, Integer> makeVideoConfig(int pair, long uid, int rate, int encodeType, int with, int height) {
        return JsonUtils.makeConfig(pair, uid, MediaVideoMsg.LiveStreamType.STREAM_TYPE_VIDEO, rate, encodeType, with, height);
    }

    private static Map<Integer, Integer> makeConfig(final int pair, final long uid, final int streamType, final int rate, final int encodeType, final int with, final int height) {
        HashMap<Integer, Integer> configs = new HashMap<Integer, Integer>(){
            {
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_TYPE, streamType);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_SPEAKER_UID, (int)uid);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_A_V_PAIR_ID, pair);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENABLE_FAST_ACCESS, 1);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_CODE_RATE, rate);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENCODE_TYPE, encodeType);
                if (streamType == 2) {
                    this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_RESOLUTION_WIDTH, with);
                    this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_RESOLUTION_HEIGHT, height);
                }
            }
        };
        return configs;
    }
}

