/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import com.yy.mediaframework.base.VideoEncoderType;

public class CodecAdapter {
    public static int toStreamManagementCodec(VideoEncoderType codec) {
        switch (codec) {
            case HARD_ENCODER_H264: 
            case SOFT_ENCODER_X264: {
                return 100;
            }
            case HARD_ENCODER_H265: 
            case SOFT_ENCODER_H265: {
                return 101;
            }
        }
        throw new RuntimeException("Unsupported preview codec value: " + codec.ordinal());
    }

    public static VideoEncoderType toPreviewCodec(int normalized) {
        switch (normalized) {
            case 201: {
                return VideoEncoderType.SOFT_ENCODER_X264;
            }
            case 220: {
                return VideoEncoderType.HARD_ENCODER_H265;
            }
            case 221: {
                return VideoEncoderType.SOFT_ENCODER_H265;
            }
        }
        return VideoEncoderType.HARD_ENCODER_H264;
    }

    public static int fromPreviewCodec(VideoEncoderType codec) {
        switch (codec) {
            case HARD_ENCODER_H264: {
                return 200;
            }
            case SOFT_ENCODER_X264: {
                return 201;
            }
            case HARD_ENCODER_H265: {
                return 220;
            }
            case SOFT_ENCODER_H265: {
                return 221;
            }
        }
        throw new RuntimeException("Unsupported preview codec value: " + codec.ordinal());
    }

    public static int getTransmissionCodec(int normalized) {
        switch (normalized) {
            case 220: 
            case 221: {
                return 2;
            }
        }
        return 1;
    }

    public static int getTransCodecFromPreviewCodec(VideoEncoderType previewCodec) {
        switch (previewCodec) {
            case HARD_ENCODER_H264: 
            case SOFT_ENCODER_X264: {
                return 1;
            }
            case HARD_ENCODER_H265: 
            case SOFT_ENCODER_H265: {
                return 2;
            }
        }
        throw new RuntimeException("Unsupported preview codec value: " + previewCodec.ordinal());
    }

    public static int fromTransmissionCodec(int type) {
        switch (type) {
            case 1: {
                return 200;
            }
            case 2: {
                return 220;
            }
        }
        throw new RuntimeException("Unsupported preview codec value: " + type);
    }

    public static boolean isHardwareEncoderType(VideoEncoderType codec) {
        switch (codec) {
            case HARD_ENCODER_H264: 
            case HARD_ENCODER_H265: {
                return true;
            }
            case SOFT_ENCODER_X264: 
            case SOFT_ENCODER_H265: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported preview codec value: " + codec.ordinal());
    }
}

