/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.trigger;

import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.trigger.PeriodicJob;
import com.yy.yylivekit.trigger.Pulse;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PeriodicTrigger {
    private static final String TAG = "PeriodicTrigger";
    private final List<PeriodicJob> jobs;
    private TriggerRunner triggerRunner;
    private Pulse ticker;

    public PeriodicTrigger(Pulse ticker) {
        YLKLog.i(TAG, "PeriodicTrigger() called with: ticker = [" + ticker + "]");
        this.jobs = Collections.synchronizedList(new ArrayList());
        this.ticker = ticker;
        this.triggerRunner = new TriggerRunner(this.jobs);
    }

    public void start() {
        YLKLog.i(TAG, "PeriodicTrigger start called");
        this.ticker.start(this.triggerRunner);
    }

    public void stop() {
        YLKLog.i(TAG, "PeriodicTrigger stop called");
        if (!FP.empty(this.jobs)) {
            this.jobs.clear();
        }
        this.ticker.stop();
    }

    public boolean isAliav() {
        return this.ticker.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(PeriodicJob job) {
        job.lastInvalidate = System.currentTimeMillis();
        job.lastFire = System.currentTimeMillis();
        job.state = PeriodicJob.State.Idle;
        List<PeriodicJob> list = this.jobs;
        synchronized (list) {
            boolean ret = this.jobs.add(job);
            YLKLog.i(TAG, "addJob called with:" + Thread.currentThread().getId() + " job = [" + job + "], ret = [" + ret + "] jobSize=" + FP.size(this.jobs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(PeriodicJob job) {
        YLKLog.i(TAG, "removeJob called with: job = [" + job + "]");
        List<PeriodicJob> list = this.jobs;
        synchronized (list) {
            boolean isSuccess = this.jobs.remove(job);
            YLKLog.i(TAG, "removeJob result:" + isSuccess + ", jobList=" + this.jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWithCondition(Condition condition) {
        YLKLog.i(TAG, "removeWithCondition() called with: condition = [" + condition + "]");
        List<PeriodicJob> list = this.jobs;
        synchronized (list) {
            Iterator<PeriodicJob> it = this.jobs.iterator();
            while (it.hasNext()) {
                PeriodicJob object = it.next();
                if (!condition.satisfy(object)) continue;
                YLKLog.i(TAG, "removeWithCondition() called with: Object = [" + object + "]");
                it.remove();
            }
        }
    }

    class TriggerRunner
    implements Runnable {
        List<PeriodicJob> jobs;

        public TriggerRunner(List<PeriodicJob> jobs) {
            this.jobs = jobs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<PeriodicJob> list = this.jobs;
            synchronized (list) {
                final Iterator<PeriodicJob> iterator = this.jobs.iterator();
                while (iterator.hasNext()) {
                    PeriodicJob job = iterator.next();
                    Boolean shouldTrigger = job.condition.shouldTrigger();
                    if (job.state == PeriodicJob.State.Firing || !shouldTrigger.booleanValue()) continue;
                    final long now = System.currentTimeMillis();
                    Boolean stale = job.lastFire <= job.lastInvalidate;
                    Boolean charged = now - job.lastInvalidate >= job.intervalMillis;
                    if (!stale.booleanValue() || !charged.booleanValue() && !job.immediately) continue;
                    job.state = PeriodicJob.State.Firing;
                    job.action.onTrigger(job, new PeriodicJob.Completion(){

                        @Override
                        public void onComplete(PeriodicJob job, Boolean success) {
                            if (success.booleanValue()) {
                                job.immediately = false;
                                job.lastFire = now;
                                if (job.autoRepeat) {
                                    job.lastInvalidate = now;
                                } else {
                                    iterator.remove();
                                }
                            }
                            job.state = PeriodicJob.State.Idle;
                        }
                    });
                }
            }
        }
    }

    public static interface Condition<T extends PeriodicJob> {
        public boolean satisfy(T var1);
    }
}

