/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.services;

import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.nano.MessageNano;
import com.yy.livekit.protocol.nano.StreamConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKEngine;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.HardwareEncodeBlacklist;
import com.yy.yylivekit.model.HeartbeatIntervalSec;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.model.NewSystemSupports;
import com.yy.yylivekit.model.VideoParams;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.utils.JsonUtils;
import com.yy.yylivekit.utils.RuntimeKit;
import com.yyproto.db.DCImpl;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.json.JSONException;
import org.json.JSONObject;

public class OpGetMediaMeta
implements Service.Operation {
    private static final String TAG = "OpGetMediaMeta";
    private final Channel channel;
    private final Purpose purpose;
    private final Failure failure;

    public OpGetMediaMeta(Channel channel, Purpose purpose, Failure failure) {
        Assert.assertNotNull((String)"\u5fc5\u987b\u63d0\u4f9bChannel\u624d\u80fd\u83b7\u53d6MediaMeta\u6570\u636e", (Object)channel);
        this.channel = channel;
        this.purpose = purpose;
        this.failure = failure;
    }

    @Override
    public int serviceType() {
        return 10588;
    }

    @Override
    public int serviceNumber() {
        return 9700;
    }

    @Override
    public int jobNumber() {
        return 51;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public Service.Operation.PackType type() {
        return Service.Operation.PackType.Normal;
    }

    @Override
    public void packRequest(Pack pack) {
        try {
            StreamConfig.GetStreamConfigReq streamConfigReq = new StreamConfig.GetStreamConfigReq();
            streamConfigReq.seq = System.currentTimeMillis();
            streamConfigReq.appid = YLKEngine.getSceneId();
            streamConfigReq.bid = 0;
            streamConfigReq.cid = (int)(this.channel != null ? this.channel.top : 0L);
            streamConfigReq.sid = (int)(this.channel != null ? this.channel.sub : 0L);
            streamConfigReq.uid = (int)DCImpl.getUserId();
            streamConfigReq.appkeys = this.purpose.key();
            streamConfigReq.params = this.lvalueFactors(this.purpose.lvalue()).getBytes("UTF-8");
            streamConfigReq.clientVer = RuntimeKit.appVersion(Env.instance().context());
            byte[] bytes = MessageNano.toByteArray((MessageNano)streamConfigReq);
            pack.pushNoTag(bytes);
            YLKLog.i("YLK", "OpGetMediaMeta seq:" + streamConfigReq.seq + ",purposeKey:" + Arrays.toString(this.purpose.key()) + ",uid:" + DCImpl.getUserId() + ",serviceType:" + this.serviceType() + ",channel:" + this.channel);
        }
        catch (Throwable e) {
            YLKLog.e("YLK", "OpGetMediaMeta packRequest Throwable:" + e);
        }
    }

    @Override
    public void processResponse(int responseNumber, Unpack unpack) {
        StreamConfig.GetStreamConfigResp streamConfigResp = new StreamConfig.GetStreamConfigResp();
        byte[] bytes = unpack.toArray();
        try {
            MessageNano.mergeFrom((MessageNano)streamConfigResp, (byte[])bytes);
        }
        catch (Throwable e) {
            YLKLog.e("YLK", "OpGetMediaMeta processResponse Throwable:" + e);
        }
        YLKLog.i("YLK", "OpGetMediaMeta response seq:" + streamConfigResp.seq + ",ret:" + streamConfigResp.ret);
        if (FP.empty(streamConfigResp.config)) {
            YLKLog.e("YLK", "OpGetMediaMeta processResponse config null");
            this.failure.didFailGettingMediaMeta();
            return;
        }
        this.purpose.process(streamConfigResp.config);
    }

    private String lvalueFactors(Map<String, Object> lvalue) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("version", (Object)Env.instance().configsVersion());
            jsonObject.put("model", (Object)Build.MODEL.toLowerCase());
            jsonObject.put("os", (Object)"android");
            jsonObject.put("osversion", (Object)Build.VERSION.RELEASE);
            jsonObject.put("ismac", false);
            jsonObject.put("electric_quantity", 0);
            jsonObject.put("power_source", 0);
            jsonObject.put("terminalType", 0);
            jsonObject.put("bitrate", 0);
            jsonObject.put("width", 0);
            jsonObject.put("framerate", 0);
            jsonObject.put("height", 0);
            if (!FP.empty(lvalue)) {
                for (Map.Entry<String, Object> entry : lvalue.entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
            }
            YLKLog.i(TAG, "lvalueFactors lvalue = [" + jsonObject.toString() + "]");
        }
        catch (Throwable e) {
            YLKLog.e(TAG, "OpGetMediaMeta lvalueFactors Throwable:" + e);
        }
        return jsonObject.toString();
    }

    public static class ForPublishEncodeMeta
    implements Purpose {
        private static final String TAG = "ForPublishEncodeMeta";
        private static final String[] DefaultPublishConfigKey = new String[]{"mob_anchor_config", "mob_hwEncoder_config"};
        private static final Map<String, String[]> OtherAppPublishConfigKey = new HashMap<String, String[]>(2){
            {
                this.put("yym101and", new String[]{"yijian_anchor_config", "mob_hwEncoder_config"});
            }
        };
        private final Completion completion;
        private final String[] targetPublishConfigKey;

        public ForPublishEncodeMeta(Completion completion) {
            this.completion = completion;
            Object[] keys = OtherAppPublishConfigKey.get(Env.instance().names().business);
            this.targetPublishConfigKey = !FP.empty((Object[])keys) ? keys : DefaultPublishConfigKey;
        }

        @Override
        public String[] key() {
            return this.targetPublishConfigKey;
        }

        @Override
        public Map<String, Object> lvalue() {
            return null;
        }

        @Override
        public void process(Map<String, String> config) {
            String anchorConfig = config.get(this.key()[0]);
            String hwEncodeConfig = config.get(this.key()[1]);
            try {
                HardwareEncodeBlacklist blacklist = this.parseHardwareEncodeBlacklist(hwEncodeConfig);
                Map<String, Object> anchorConfigMap = this.parseAnchorConfig(anchorConfig, blacklist);
                int modifyInterval = (Integer)anchorConfigMap.get("modifyInterval");
                Map encodeMetaMap = (Map)anchorConfigMap.get("encodeMetaMap");
                YLKLog.i(TAG, "finish Purpose " + Arrays.toString(this.key()));
                this.completion.didGetEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
            }
            catch (JSONException e) {
                YLKLog.e(TAG, "parse data failed!!" + Log.getStackTraceString((Throwable)e));
            }
        }

        public void getDefaultConfig() {
            YLKLog.i(TAG, "getDefaultConfig");
            try {
                HardwareEncodeBlacklist blacklist = this.parseHardwareEncodeBlacklist("{\"anchor\":{\"blackCodec\":[\"OMX.IMG.TOPAZ.VIDEO.Encoder\"],\"blackModel\":[\"SM-N9006\",\"SM-N900\",\"Moto X Pro\",\"HM 2A\",\"Lenovo A938t\",\"HUAWEI P7-L09\",\"HUAWEI P7-L07\",\"L39u\",\"Lenovo A788t\",\"Coolpad 8720L\",\"Coolpad 8705\",\"vivo X5Pro D\",\"SCL-CL00\",\"GT-I9300\",\"HS-X8T\",\"vivo V3M A\",\"vivo X5L\"]}}");
                Map<String, Object> anchorConfigMap = this.parseAnchorConfig("{\"anchor\":{\n    \"entEncode\":1,\n    \"bframeswitch\": 0,\n    \"resolutionModifyInterval\":10,\n    \"resolution2\":[\n        {\n            \"key\":1,\n            \"width\":368,\n            \"height\":640,\n            \"codeRate\":800,\n            \"currate\":800,\n            \"frameRate\":24,\n            \"isDefault\":0,\n            \"meiyan\":\"\",\n            \"encode_id\":200,\n            \"param\":\"\",\n            \"modifyConfig\":[\n                {\n                    \"width\":368,\n                    \"height\":640,\n                    \"minCodeRate\":200,\n                    \"maxCodeRate\":800,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                }\n            ]\n        },\n        {\n            \"key\":2,\n            \"width\":544,\n            \"height\":960,\n            \"codeRate\":1200,\n            \"currate\":1200,\n            \"frameRate\":24,\n            \"isDefault\":1,\n            \"meiyan\":\"\",\n            \"encode_id\":200,\n            \"param\":\"\",\n            \"modifyConfig\":[\n                {\n                    \"width\":368,\n                    \"height\":640,\n                    \"minCodeRate\":200,\n                    \"maxCodeRate\":1000,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                },\n                {\n                    \"width\":544,\n                    \"height\":960,\n                    \"minCodeRate\":600,\n                    \"maxCodeRate\":1200,\n                    \"minFrameRate\":15,\n                    \"maxFrameRate\":24\n                }\n            ]\n        }\n    ]\n}}", blacklist);
                int modifyInterval = (Integer)anchorConfigMap.get("modifyInterval");
                Map encodeMetaMap = (Map)anchorConfigMap.get("encodeMetaMap");
                YLKLog.i(TAG, "finish default Purpose " + Arrays.toString(this.key()));
                this.completion.didGetEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
            }
            catch (JSONException e) {
                YLKLog.e(TAG, "parse data failed!!" + Log.getStackTraceString((Throwable)e));
            }
        }

        private HardwareEncodeBlacklist parseHardwareEncodeBlacklist(String config) {
            YLKLog.i(TAG, "parseHardwareEncodeBlacklist " + config);
            if (FP.empty((CharSequence)config)) {
                return new HardwareEncodeBlacklist(Collections.EMPTY_SET, Collections.EMPTY_SET);
            }
            return JsonUtils.parseHardwareEncodeBlacklist(config);
        }

        private Map<String, Object> parseAnchorConfig(String anchorConfig, HardwareEncodeBlacklist blackList) throws JSONException {
            YLKLog.i(TAG, "parseAnchorConfig " + anchorConfig);
            if (FP.empty((CharSequence)anchorConfig)) {
                return Collections.emptyMap();
            }
            return JsonUtils.parsePublishEncodeConfig(anchorConfig, blackList);
        }

        public static interface Completion {
            public void didGetEncodeMeta(Integer var1, Map<Integer, LiveMeta.EncodeMeta> var2, HardwareEncodeBlacklist var3);
        }
    }

    public static class ForLinkMicEncodeMeta
    implements Purpose {
        private static final String TAG = "ForLinkMicEncodeMeta";
        Completion completion;
        VideoParams videoParams;
        boolean isLinkMic = false;
        String[] targetAnchorStreamKey;

        public ForLinkMicEncodeMeta(VideoParams videoParams, boolean islinkmic, Completion completion) {
            Assert.assertNotNull((String)"videoParams must not nll", (Object)videoParams);
            YLKLog.i(TAG, "ForLinkMicEncodeMeta videoParams = [" + videoParams + "], islinkmic = [" + islinkmic + "]");
            this.completion = completion;
            this.videoParams = videoParams;
            this.isLinkMic = islinkmic;
            this.targetAnchorStreamKey = "yym101and".equals(Env.instance().names().business) ? new String[]{"yijian_linkmic_config"} : new String[]{"mob_linkmic_config"};
        }

        @Override
        public String[] key() {
            return this.targetAnchorStreamKey;
        }

        @Override
        public Map<String, Object> lvalue() {
            return new HashMap<String, Object>(){
                {
                    this.put("ismac", ForLinkMicEncodeMeta.this.isLinkMic);
                    this.put("bitrate", ForLinkMicEncodeMeta.this.videoParams.currate / 1000);
                    this.put("width", ForLinkMicEncodeMeta.this.videoParams.width);
                    this.put("framerate", ForLinkMicEncodeMeta.this.videoParams.frameRate);
                    this.put("height", ForLinkMicEncodeMeta.this.videoParams.height);
                    this.put("hevc", ForLinkMicEncodeMeta.this.hevc(ForLinkMicEncodeMeta.this.videoParams.encodeType));
                    this.put("scale", ForLinkMicEncodeMeta.this.videoParams.width < ForLinkMicEncodeMeta.this.videoParams.height ? "9_16" : "16_9");
                }
            };
        }

        private String hevc(VideoEncoderType type) {
            switch (type) {
                case SOFT_ENCODER_H265: 
                case HARD_ENCODER_H265: {
                    return "h265";
                }
            }
            return "h264";
        }

        @Override
        public void process(Map<String, String> config) {
            String response = config.get(this.key()[0]);
            this.completion.didGetLinkMicEncodeMeta(response);
        }

        public static interface Completion {
            public void didGetLinkMicEncodeMeta(String var1);
        }
    }

    public static class ForSystemParams
    implements Purpose {
        private final Completion completion;

        public ForSystemParams(Completion completion) {
            this.completion = completion;
        }

        @Override
        public String[] key() {
            return new String[]{"sysparam"};
        }

        @Override
        public Map<String, Object> lvalue() {
            return null;
        }

        @Override
        public void process(Map<String, String> config) {
            HeartbeatIntervalSec heartbeatIntervalSec;
            JsonArray channelIDsArray;
            NewSystemSupports.Mode mode;
            JsonParser parser = new JsonParser();
            String response = config.get(this.key()[0]);
            YLKLog.i("YLK", "OpGetMediaMeta ForSystemParams response:" + response);
            JsonElement element = parser.parse(response).getAsJsonObject().get("sysparam");
            Assert.assertTrue((element != null && !element.isJsonNull() ? 1 : 0) != 0);
            JsonObject rootObj = element.getAsJsonObject();
            if (rootObj.get("newmodel").getAsInt() == 0) {
                mode = NewSystemSupports.Mode.WhiteList;
                channelIDsArray = rootObj.get("whitecids").getAsJsonArray();
            } else {
                mode = NewSystemSupports.Mode.BlackList;
                channelIDsArray = rootObj.get("blackcids").getAsJsonArray();
            }
            if (rootObj.has("video_heartbeat_time")) {
                long video = rootObj.get("video_heartbeat_time").getAsLong();
                long audioOnly = rootObj.get("only_audio_heartbeat_time").getAsLong();
                heartbeatIntervalSec = new HeartbeatIntervalSec(video, audioOnly);
            } else {
                heartbeatIntervalSec = new HeartbeatIntervalSec(5L, 30L);
            }
            List list = (List)new Gson().fromJson((JsonElement)channelIDsArray, new TypeToken<List<Long>>(){}.getType());
            this.completion.didGetSystemParams(new NewSystemSupports(mode, list), heartbeatIntervalSec);
        }

        public static interface Completion {
            public void didGetSystemParams(NewSystemSupports var1, HeartbeatIntervalSec var2);
        }
    }

    public static class ForLiveMeta
    implements Purpose {
        final String[] targetAnchorStreamKey;
        private final LiveMeta.EncodeMeta encodeMeta;
        private final Completion completion;

        ForLiveMeta(LiveMeta.EncodeMeta encodeMeta, Completion completion) {
            this.encodeMeta = encodeMeta;
            this.completion = completion;
            this.targetAnchorStreamKey = "yym101and".equals(Env.instance().names().business) ? new String[]{"yijian_anchor_stream"} : new String[]{"mob_anchor_stream"};
        }

        @Override
        public String[] key() {
            return this.targetAnchorStreamKey;
        }

        @Override
        public Map<String, Object> lvalue() {
            return null;
        }

        @Override
        public void process(Map<String, String> config) {
            JsonParser parser = new JsonParser();
            String response = config.get(this.key()[0]);
            YLKLog.i("YLK", "OpGetMediaMeta ForLiveMeta response:" + response);
            JsonElement streamNode = parser.parse(response).getAsJsonObject().get("stream");
            Assert.assertTrue((streamNode != null && !streamNode.isJsonNull() ? 1 : 0) != 0);
            JsonObject streamObj = streamNode.getAsJsonObject();
            this.completion.didGetLiveMeta(this.makeStreamMetaList(this.streamNamesFromObject(streamObj)));
        }

        private LiveMeta makeStreamMetaList(Map<String, Map<String, String>> streamNames) {
            Assert.assertNotNull((String)"\u6d41\u540d\u79f0\u7684\u6863\u4f4d\u914d\u7f6e\u4e0d\u4e00\u5b9a\u5b58\u5728\uff0c\u4f46default\u914d\u7f6e\u662f\u5fc5\u987b\u5b58\u5728\u7684", (Object)streamNames.containsKey("default"));
            int level = this.encodeMeta.key;
            Map<String, String> nameSet = streamNames.get(String.valueOf(level));
            if (nameSet == null) {
                nameSet = streamNames.get("default");
            }
            Assert.assertTrue((nameSet != null ? 1 : 0) != 0);
            LiveMeta.AudioMeta audioMeta = new LiveMeta.AudioMeta(nameSet.get("audioName"), nameSet.get("audioGroup"));
            LiveMeta.VideoMeta videoMeta = new LiveMeta.VideoMeta(nameSet.get("videoName"), this.encodeMeta);
            String groupName = new String(nameSet.get("audioGroup"));
            return new LiveMeta(level, videoMeta, audioMeta, groupName);
        }

        private Map<String, Map<String, String>> streamNamesFromObject(JsonObject streamObj) {
            HashMap<String, Map<String, String>> streamNames = new HashMap<String, Map<String, String>>();
            for (String key : streamObj.keySet()) {
                String audioName = null;
                String audioGroup = null;
                String videoName = null;
                JsonArray metaArray = streamObj.get(key).getAsJsonArray();
                for (JsonElement metaItem : metaArray) {
                    JsonObject metaObj = metaItem.getAsJsonObject();
                    int type = metaObj.get("type").getAsInt();
                    String name = metaObj.get("stream_name").getAsString();
                    if (type == 2) {
                        videoName = name;
                        continue;
                    }
                    if (type != 1) continue;
                    audioName = name;
                    audioGroup = metaObj.get("stream_group").getAsString();
                }
                if (audioName == null || videoName == null || audioGroup == null) continue;
                HashMap<String, String> bundle = new HashMap<String, String>();
                bundle.put("audioName", audioName);
                bundle.put("videoName", videoName);
                bundle.put("audioGroup", audioGroup);
                streamNames.put(key, bundle);
            }
            return streamNames;
        }

        public static interface Completion {
            public void didGetLiveMeta(LiveMeta var1);
        }
    }

    public static class ForViewerConfig
    implements Purpose {
        final Completion completion;

        public ForViewerConfig(Completion completion) {
            this.completion = completion;
        }

        @Override
        public String[] key() {
            return new String[]{"mob_viewer_config"};
        }

        @Override
        public Map<String, Object> lvalue() {
            return null;
        }

        @Override
        public void process(Map<String, String> config) {
            String viewerConfig = config.get(this.key()[0]);
            if (!FP.empty((CharSequence)viewerConfig)) {
                YLKLog.i(OpGetMediaMeta.TAG, "ForViewerConfig get success!!" + viewerConfig);
                try {
                    List<Integer> h264Thresholds = Collections.EMPTY_LIST;
                    List<Integer> h265Thresholds = Collections.EMPTY_LIST;
                    JSONObject vcObj = new JSONObject(viewerConfig);
                    JSONObject crldObj = vcObj.optJSONObject("codeRateLevelDefinition");
                    JSONObject h265dsObj = vcObj.optJSONObject("h265DecodeSupport");
                    if (crldObj != null) {
                        JSONObject h264Levels = crldObj.optJSONObject("h264");
                        JSONObject h265Levels = crldObj.optJSONObject("h265");
                        h264Thresholds = this.parseCodeRateRange(h264Levels);
                        h265Thresholds = this.parseCodeRateRange(h265Levels);
                    }
                    int h265Suport = h265dsObj != null ? h265dsObj.optInt("h265DecodeSupport", 0) : 0;
                    this.completion.didGetMediaConfigs(viewerConfig, new YLKMediaConfigs(h264Thresholds, h265Thresholds, h265Suport, Collections.EMPTY_MAP));
                }
                catch (JSONException e) {
                    YLKLog.e(OpGetMediaMeta.TAG, "ForViewerConfig get failed!!" + Log.getStackTraceString((Throwable)e));
                }
            }
        }

        private List<Integer> parseCodeRateRange(JSONObject jsonObj) {
            String[] rateLevelName = new String[]{"standard", "high", "super"};
            ArrayList<Integer> codeRange = new ArrayList<Integer>();
            for (String name : rateLevelName) {
                codeRange.add(jsonObj.optInt(name));
            }
            return codeRange;
        }

        public static interface Completion {
            public void didGetMediaConfigs(String var1, YLKMediaConfigs var2);
        }
    }

    public static interface Failure {
        public void didFailGettingMediaMeta();
    }

    public static interface Purpose {
        public String[] key();

        public Map<String, Object> lvalue();

        public void process(Map<String, String> var1);
    }
}

