/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.observables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public class ObservableMap<KeyType, ValueType> {
    private HashMap<KeyType, ValueType> dictionary = new HashMap();
    private HashMap<Object, ArrayList<Observer<KeyType, ValueType>>> observers = new HashMap();

    private void forAllObservers(Iterator<KeyType, ValueType> iterator) {
        for (ArrayList<Observer<KeyType, ValueType>> list : this.observers.values()) {
            for (Observer<KeyType, ValueType> o : list) {
                iterator.iterate(o);
            }
        }
    }

    public int size() {
        return this.dictionary.size();
    }

    public Set<KeyType> keySet() {
        return this.dictionary.keySet();
    }

    public Collection<ValueType> values() {
        return this.dictionary.values();
    }

    public void put(final KeyType key, final ValueType value) {
        if (this.dictionary.containsKey(key)) {
            this.remove(key);
        }
        this.forAllObservers(new Iterator<KeyType, ValueType>(){

            @Override
            public void iterate(Observer<KeyType, ValueType> observer) {
                observer.willAdd(key, value);
            }
        });
        this.dictionary.put(key, value);
        this.forAllObservers(new Iterator<KeyType, ValueType>(){

            @Override
            public void iterate(Observer<KeyType, ValueType> observer) {
                observer.didAdd(key, value);
                observer.updated(ObservableMap.this.dictionary);
            }
        });
    }

    public ValueType get(KeyType key) {
        return this.dictionary.get(key);
    }

    public Boolean contains(KeyType key) {
        return this.dictionary.get(key) != null;
    }

    public void remove(final KeyType key) {
        Assert.assertTrue((boolean)this.dictionary.containsKey(key));
        final ValueType value = this.dictionary.get(key);
        this.forAllObservers(new Iterator<KeyType, ValueType>(){

            @Override
            public void iterate(Observer<KeyType, ValueType> observer) {
                observer.willRemove(key, value);
            }
        });
        this.dictionary.remove(key);
        this.forAllObservers(new Iterator<KeyType, ValueType>(){

            @Override
            public void iterate(Observer<KeyType, ValueType> observer) {
                observer.didRemove(key, value);
                observer.updated(ObservableMap.this.dictionary);
            }
        });
    }

    public void clear() {
        Object[] keys;
        for (Object key : keys = this.dictionary.keySet().toArray()) {
            this.remove(key);
        }
    }

    public void register(Object context, Boolean wantsInitial, Observer<KeyType, ValueType> observer) {
        ArrayList<Observer<Object, Object>> list = this.observers.get(context);
        if (list == null) {
            list = new ArrayList();
            this.observers.put(context, list);
        }
        list.add(observer);
        if (wantsInitial.booleanValue()) {
            observer.updated(this.dictionary);
        }
    }

    public void unregister(Object context) {
        this.observers.remove(context);
    }

    public static abstract class Observer<InnerKey, InnerValue> {
        public void willAdd(InnerKey key, InnerValue value) {
        }

        public void didAdd(InnerKey key, InnerValue value) {
        }

        public void willRemove(InnerKey key, InnerValue value) {
        }

        public void didRemove(InnerKey key, InnerValue value) {
        }

        public void updated(Map<InnerKey, InnerValue> values) {
        }
    }

    private static interface Iterator<InnerKey, InnerValue> {
        public void iterate(Observer<InnerKey, InnerValue> var1);
    }
}

