/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StreamFilters {
    private static final String TAG = "StreamFilters";

    public static List<StreamInfo> filter(List<StreamInfo> streams, StreamFilter[] filters) {
        for (StreamFilter it : filters) {
            streams = it.filter(streams);
        }
        return streams;
    }

    private static List<StreamInfo> streamsByEncodeType(List<StreamInfo> originals, int encodeType) {
        YLKLog.i(TAG, "streamsByEncodeType() called with: originals = [" + originals + "], encodeType = [" + encodeType + "]");
        ArrayList<StreamInfo> results = new ArrayList<StreamInfo>();
        for (StreamInfo streams : originals) {
            if (streams.video == null || streams.video.encode != encodeType) continue;
            results.add(streams);
        }
        YLKLog.i(TAG, "streamsByEncodeType() results = [" + results + "]");
        return results;
    }

    public static final class EncodePreferenceFilter
    implements StreamFilter {
        private final boolean h265preferred;

        public EncodePreferenceFilter(boolean h265preferred) {
            this.h265preferred = h265preferred;
        }

        private StreamInfo chooseHightRate(StreamInfo cache, StreamInfo compare) {
            if (compare == null) {
                return cache;
            }
            return cache.video.codeRate > compare.video.codeRate ? cache : compare;
        }

        private Map<Integer, List<StreamInfo>> splitStreamByVideoType(List<StreamInfo> originals) {
            HashMap<Integer, List<StreamInfo>> splitStreams = new HashMap<Integer, List<StreamInfo>>(){
                {
                    this.put(100, new ArrayList());
                    this.put(101, new ArrayList());
                }
            };
            for (StreamInfo si : originals) {
                if (si.video != null && si.video.encode == 100) {
                    ((List)splitStreams.get(100)).add(si);
                }
                if (si.video == null || si.video.encode != 101) continue;
                ((List)splitStreams.get(101)).add(si);
            }
            return splitStreams;
        }

        @Override
        public List<StreamInfo> filter(List<StreamInfo> originals) {
            YLKLog.i(StreamFilters.TAG, "filter() called with: originals = [" + originals + "]");
            Map<Integer, List<StreamInfo>> all = this.splitStreamByVideoType(originals);
            HashMap<VideoGearInfo, StreamInfo> mixtures = new HashMap<VideoGearInfo, StreamInfo>();
            for (StreamInfo h264 : all.get(100)) {
                StreamInfo si = this.chooseHightRate(h264, (StreamInfo)mixtures.get(h264.video.videoGearInfo));
                if (si.type == 2) {
                    mixtures.put(h264.video.videoGearInfo, si);
                    continue;
                }
                StreamInfo tmpSi = (StreamInfo)mixtures.get(h264.video.videoGearInfo);
                if (tmpSi != null && tmpSi.type < si.type) continue;
                mixtures.put(h264.video.videoGearInfo, si);
            }
            YLKLog.i(StreamFilters.TAG, "filter() finish 264: mixtures = [" + mixtures + "]");
            for (StreamInfo h265 : all.get(101)) {
                VideoGearInfo quality = h265.video.videoGearInfo;
                if (mixtures.containsKey(quality) && !this.h265preferred) continue;
                StreamInfo si = h265;
                mixtures.put(h265.video.videoGearInfo, si);
            }
            YLKLog.i(StreamFilters.TAG, "filter() finish 265: mixtures = [" + mixtures + "]");
            return new ArrayList<StreamInfo>(mixtures.values());
        }
    }

    public static interface StreamFilter {
        public List<StreamInfo> filter(List<StreamInfo> var1);
    }
}

