/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class MixVideoLayout
implements Serializable,
Cloneable {
    public final Style style;
    public final List<Params> params;

    public MixVideoLayout(Style style, List<Params> params) {
        this.style = style;
        this.params = params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MixVideoLayout that = (MixVideoLayout)o;
        if (this.style != that.style) {
            return false;
        }
        return this.params != null ? this.params.equals(that.params) : that.params == null;
    }

    public int hashCode() {
        int result = this.style != null ? this.style.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public MixVideoLayout clone() throws CloneNotSupportedException {
        ArrayList<Params> paramsList = new ArrayList<Params>();
        for (Params p : this.params) {
            paramsList.add(p.clone());
        }
        return new MixVideoLayout(this.style, paramsList);
    }

    public String toString() {
        return "MixVideoLayout{style=" + (Object)((Object)this.style) + ", params=" + this.params + '}';
    }

    public static class Params
    implements Serializable,
    Cloneable {
        public final int h;
        public final int w;
        public final int x;
        public final int y;
        public final int mic;
        public final long uid;

        public Params(int h, int w, int x, int y, int mic, long uid) {
            this.h = h;
            this.w = w;
            this.x = x;
            this.y = y;
            this.mic = mic;
            this.uid = uid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Params params = (Params)o;
            if (this.h != params.h) {
                return false;
            }
            if (this.w != params.w) {
                return false;
            }
            if (this.x != params.x) {
                return false;
            }
            if (this.y != params.y) {
                return false;
            }
            if (this.mic != params.mic) {
                return false;
            }
            return this.uid == params.uid;
        }

        public int hashCode() {
            int result = this.h;
            result = 31 * result + this.w;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.mic;
            result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
            return result;
        }

        public Params clone() {
            return new Params(this.h, this.w, this.x, this.y, this.mic, this.uid);
        }

        public String toString() {
            return "Params{h=" + this.h + ", w=" + this.w + ", x=" + this.x + ", y=" + this.y + ", mic=" + this.mic + ", uid=" + this.uid + '}';
        }
    }

    public static enum Style {
        HP,
        PIP,
        NA;

    }
}

