/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.duowan.mobile.mediaproxy.MediaInvoke;
import com.medialib.video.MediaVideoMsg;
import com.yyproto.utils.FP;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AudioInfo
implements Serializable,
Cloneable {
    public final int appId;
    public final String streamName;
    public final int pair;
    public final boolean isMix;
    public final int source;
    public final boolean isMultSource;
    private final Map<Integer, Integer> config;

    public AudioInfo(int appId, String streamName, int source, boolean isMs, int pair, boolean isMix, Map<Integer, Integer> config) {
        this.appId = appId;
        this.streamName = streamName;
        this.source = source;
        this.pair = pair;
        this.isMix = isMix;
        this.config = config;
        this.isMultSource = isMs;
    }

    public AudioInfo clone() {
        HashMap<Integer, Integer> targetConfig = new HashMap<Integer, Integer>();
        if (!FP.empty(this.config)) {
            targetConfig.putAll(this.config);
        }
        return new AudioInfo(this.appId, this.streamName, this.source, this.isMultSource, this.pair, this.isMix, targetConfig);
    }

    public String toString() {
        return "AudioInfo{appId=" + this.appId + ", streamName='" + this.streamName + '\'' + ", pair=" + this.pair + ", isMix=" + this.isMix + ", source=" + this.source + ", isMultSource=" + this.isMultSource + ", config=" + this.config + '}';
    }

    public MediaInvoke.LiveStreamInfo liveStreamInfo() {
        return new MediaInvoke.LiveStreamInfo(this.streamName, this.config);
    }

    public void enableFastAccess(boolean enable) {
        this.config.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENABLE_FAST_ACCESS, enable ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioInfo audioInfo = (AudioInfo)o;
        if (this.appId != audioInfo.appId) {
            return false;
        }
        return this.streamName != null ? this.streamName.equals(audioInfo.streamName) : audioInfo.streamName == null;
    }

    public int hashCode() {
        int result = this.appId;
        result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
        return result;
    }
}

