/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.config;

import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.config.GetConfigStrategyEx;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.HardwareEncodeBlacklist;
import com.yy.yylivekit.model.HeartbeatIntervalSec;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.model.NewSystemSupports;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yy.yylivekit.services.OpGetMediaMeta;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.retrystrategies.RetryNone;
import com.yy.yylivekit.services.retrystrategies.RetryStrategy;
import com.yy.yylivekit.utils.FileStorageUtils;
import com.yy.yylivekit.utils.JsonUtils;
import com.yy.yylivekit.utils.VideoQualityCalc;
import com.yyproto.utils.FP;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class ConfigRepo {
    private static final String TAG = "ConfigRequestManager";
    private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
    private Env env = Env.instance();
    private Map<InitConfig, GetConfigStrategyEx> configs = this.createConfigs();

    private ConfigRepo() {
    }

    public static ConfigRepo getInstance() {
        return Holder.INSTANCE;
    }

    public void loadConfig(boolean isDefault) {
        YLKLog.i(TAG, "loadConfig called with: isDefault = [" + isDefault + "]");
        for (Map.Entry<InitConfig, GetConfigStrategyEx> entry : this.getConfigs().entrySet()) {
            GetConfigStrategyEx strategyEx = entry.getValue();
            if (isDefault) {
                strategyEx.getDefault();
                continue;
            }
            if (strategyEx.shouldLoadFromNet()) {
                strategyEx.getFromService();
                continue;
            }
            YLKLog.i(TAG, String.format("ignore load config: %s, isRequesting: %b, hasLoaded: %b", strategyEx.getLogTag(), strategyEx.mIsRequestingFromNet, strategyEx.mHasLoadedFromNet));
        }
    }

    private Map<InitConfig, GetConfigStrategyEx> createConfigs() {
        return new HashMap<InitConfig, GetConfigStrategyEx>(){
            {
                if ("0".equals("1")) {
                    this.put(InitConfig.EncodeMetaUpdate, ConfigRepo.this.encodeMetaUpdateStrategy());
                }
                this.put(InitConfig.SystemParamInit, ConfigRepo.this.sysParamInitStrategy());
                this.put(InitConfig.MediaConfigUpdate, ConfigRepo.this.mediaConfigStrategy());
            }
        };
    }

    private GetConfigStrategyEx mediaConfigStrategy() {
        return new GetConfigStrategyEx(){

            @Override
            public String getLogTag() {
                return "viewerConfig";
            }

            @Override
            public void getDefault() {
                YLKLog.i(ConfigRepo.TAG, "viewerConfig getDefault called");
                String viewerConfig = FileStorageUtils.getCache(Env.instance().context(), "viewerConfig");
                boolean needUseDefault = false;
                if (!FP.empty((CharSequence)viewerConfig)) {
                    try {
                        List<Integer> h264Thresholds = Collections.EMPTY_LIST;
                        List<Integer> h265Thresholds = Collections.EMPTY_LIST;
                        JSONObject vcObj = new JSONObject(viewerConfig);
                        JSONObject crldObj = vcObj.optJSONObject("codeRateLevelDefinition");
                        JSONObject h265dsObj = vcObj.optJSONObject("h265DecodeSupport");
                        if (crldObj != null) {
                            JSONObject h264Levels = crldObj.optJSONObject("h264");
                            JSONObject h265Levels = crldObj.optJSONObject("h265");
                            h264Thresholds = JsonUtils.parseCodeRateRange(h264Levels);
                            h265Thresholds = JsonUtils.parseCodeRateRange(h265Levels);
                        }
                        int h265Suport = h265dsObj != null ? h265dsObj.optInt("h265DecodeSupport", 0) : 0;
                        YLKLog.i(ConfigRepo.TAG, "didGetMediaConfigs cacheMediaConfig = " + viewerConfig);
                        ConfigRepo.this.env.onUpdateMediaConfig(new YLKMediaConfigs(h264Thresholds, h265Thresholds, h265Suport, Collections.EMPTY_MAP));
                    }
                    catch (Exception e) {
                        needUseDefault = true;
                    }
                }
                if (needUseDefault) {
                    YLKMediaConfigs defaultMediaConfig = VideoQualityCalc.getDefaultMediaConfigs();
                    final int h264DecodeType = defaultMediaConfig.isH264HardwareDecodeAvailable() ? 1 : 0;
                    final int h265DecodeType = defaultMediaConfig.isH265HardwareDecodeAvailable() ? 1 : 0;
                    YLKLog.i(ConfigRepo.TAG, "didGetMediaConfigs defaultMediaConfig = [" + defaultMediaConfig + "]");
                    IMediaVideo media = IMediaVideoSDK.instance().getMedia();
                    media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                        {
                            this.put(316, h265DecodeType);
                            this.put(302, h264DecodeType);
                        }
                    });
                    ConfigRepo.this.env.onUpdateMediaConfig(defaultMediaConfig);
                }
            }

            @Override
            public void getFromService() {
                this.mIsRequestingFromNet = true;
                YLKLog.i(ConfigRepo.TAG, "viewerConfig getFromService called");
                OpGetMediaMeta.ForViewerConfig forViewerConfig = new OpGetMediaMeta.ForViewerConfig(new OpGetMediaMeta.ForViewerConfig.Completion(){

                    @Override
                    public void didGetMediaConfigs(String orginal, YLKMediaConfigs liveRoomParams) {
                        mHasLoadedFromNet = true;
                        mIsRequestingFromNet = false;
                        if (!FP.empty((CharSequence)orginal)) {
                            FileStorageUtils.setCache(orginal, Env.instance().context(), "viewerConfig", 0);
                        }
                        YLKLog.i(ConfigRepo.TAG, "didGetMediaConfigs liveRoomParams = [" + liveRoomParams + "]");
                        final int h264DecodeType = liveRoomParams.isH264HardwareDecodeAvailable() ? 1 : 0;
                        final int h265DecodeType = liveRoomParams.isH265HardwareDecodeAvailable() ? 1 : 0;
                        ConfigRepo.this.media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                            {
                                if (!Env.instance().isCustomerSetH265HwEnable()) {
                                    this.put(316, h265DecodeType);
                                }
                                if (!Env.instance().isCustomerSetH264HwEnable()) {
                                    this.put(302, h264DecodeType);
                                }
                            }
                        });
                        ConfigRepo.this.env.onUpdateMediaConfig(liveRoomParams);
                    }
                });
                Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forViewerConfig, new OpGetMediaMeta.Failure(){

                    @Override
                    public void didFailGettingMediaMeta() {
                        mHasLoadedFromNet = false;
                        mIsRequestingFromNet = false;
                        this.getDefault();
                    }
                }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
            }
        };
    }

    private GetConfigStrategyEx sysParamInitStrategy() {
        return new GetConfigStrategyEx(){

            @Override
            public String getLogTag() {
                return "sysParamInit";
            }

            @Override
            public void getDefault() {
                YLKLog.i(ConfigRepo.TAG, "sysParamInit getDefault called");
                NewSystemSupports newSystem = new NewSystemSupports(NewSystemSupports.Mode.BlackList, Collections.EMPTY_LIST);
                HeartbeatIntervalSec heartbeatIntervalSec = new HeartbeatIntervalSec(5L, 30L);
                ConfigRepo.this.env.onInitSysParams(newSystem, heartbeatIntervalSec);
            }

            @Override
            public void getFromService() {
                this.mIsRequestingFromNet = true;
                YLKLog.i(ConfigRepo.TAG, "sysParamInit getFromService called");
                OpGetMediaMeta.ForSystemParams forSystemParams = new OpGetMediaMeta.ForSystemParams(new OpGetMediaMeta.ForSystemParams.Completion(){

                    @Override
                    public void didGetSystemParams(NewSystemSupports supports, HeartbeatIntervalSec publisherHeartbeatIntervalSec) {
                        mHasLoadedFromNet = true;
                        mIsRequestingFromNet = false;
                        YLKLog.i(ConfigRepo.TAG, "didGetSystemParams: NewSystemSupports: " + supports);
                        ConfigRepo.this.env.onInitSysParams(supports, publisherHeartbeatIntervalSec);
                        YLKLog.i(ConfigRepo.TAG, ConfigRepo.this.env.heartbeatIntervalSec().toString());
                    }
                });
                Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forSystemParams, new OpGetMediaMeta.Failure(){

                    @Override
                    public void didFailGettingMediaMeta() {
                        mHasLoadedFromNet = false;
                        mIsRequestingFromNet = false;
                        YLKLog.e(ConfigRepo.TAG, "didFailGettingMediaMeta - ForSystemParams");
                        this.getDefault();
                    }
                }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
            }
        };
    }

    private GetConfigStrategyEx encodeMetaUpdateStrategy() {
        return new GetConfigStrategyEx(){

            @Override
            public String getLogTag() {
                return "encodeMetaUpdate";
            }

            @Override
            public void getDefault() {
                YLKLog.i(ConfigRepo.TAG, "encodeMetaUpdate getDefault called");
                new OpGetMediaMeta.ForPublishEncodeMeta(new OpGetMediaMeta.ForPublishEncodeMeta.Completion(){

                    @Override
                    public void didGetEncodeMeta(Integer modifyInterval, Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap, HardwareEncodeBlacklist blacklist) {
                        ConfigRepo.this.env.onUpdateEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
                    }
                }).getDefaultConfig();
            }

            @Override
            public void getFromService() {
                YLKLog.i(ConfigRepo.TAG, "encodeMetaUpdate getFromService called");
                this.mIsRequestingFromNet = true;
                OpGetMediaMeta.ForPublishEncodeMeta forEncodeMeta = new OpGetMediaMeta.ForPublishEncodeMeta(new OpGetMediaMeta.ForPublishEncodeMeta.Completion(){

                    @Override
                    public void didGetEncodeMeta(Integer modifyInterval, Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap, HardwareEncodeBlacklist blacklist) {
                        mHasLoadedFromNet = true;
                        mIsRequestingFromNet = false;
                        ConfigRepo.this.env.onUpdateEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
                    }
                });
                Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forEncodeMeta, new OpGetMediaMeta.Failure(){

                    @Override
                    public void didFailGettingMediaMeta() {
                        mIsRequestingFromNet = false;
                        mHasLoadedFromNet = false;
                        this.getDefault();
                    }
                }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
            }
        };
    }

    private Map<InitConfig, GetConfigStrategyEx> getConfigs() {
        return this.configs;
    }

    private static class Holder {
        private static final ConfigRepo INSTANCE = new ConfigRepo();

        private Holder() {
        }
    }

    public static enum InitConfig {
        SystemParamInit,
        EncodeMetaUpdate,
        MediaConfigUpdate;

    }
}

