/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.streamline;

import com.medialib.video.MediaVideoMsg;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.audience.streamline.AbsHandler;
import com.yy.yylivekit.audience.streamline.IComplete;
import com.yy.yylivekit.audience.streamline.IHandler;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yyproto.utils.FP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineFrom0Handler
extends AbsHandler
implements IHandler {
    private static final String TAG = "LineFrom0Handler";

    @Override
    public void handle(LivePlayer player, MediaVideoMsg.LiveStreamLineInfo liveStreamLineInfo, IComplete complete) {
        Set<LiveInfo> liveInfoSet = player.getAllLiveInfo();
        if (!this.checkAccept(liveInfoSet, new AbsHandler.AcceptOption(){

            @Override
            public boolean accept(LiveInfo info) {
                return info.isMix;
            }
        })) {
            YLKLog.e(TAG, " handle forbidden");
            return;
        }
        LiveInfo liveInfo = player.getCurLiveInfo();
        StreamInfo streamInfo = player.getCurStreamInfo();
        YLKLog.i(TAG, "handle liveInfo = [" + liveInfo + "], \nstreamInfo = [" + streamInfo + "], \nliveStreamLineInfo = [" + liveStreamLineInfo + "]");
        HashMap<Integer, Map<Integer, List<VideoGearInfo>>> fullMap = new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>();
        for (LiveInfo info : liveInfoSet) {
            if (!info.hasVideo()) continue;
            Map<Integer, List<VideoGearInfo>> lineVideoQualityMap = this.parseLSLInfo(info, liveStreamLineInfo);
            fullMap.put(info.source, lineVideoQualityMap);
        }
        if (streamInfo != null && streamInfo.video != null && this.isVideoLineInterrupt(streamInfo.video, liveStreamLineInfo) && !FP.empty((Map)((Map)fullMap.get(liveInfo.source)))) {
            YLKLog.i(TAG, "handle isVideoLineInterrupt ignore");
            return;
        }
        complete.onLiveStreamLineInfo(liveInfo.source, liveStreamLineInfo.curLineSeq, player.getCurVideoQuality(), fullMap);
    }
}

