/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.streamline;

import com.duowan.mobile.mediaproxy.MediaInvoke;
import com.medialib.video.MediaVideoMsg;
import com.yy.IMediaVideoSDK;
import com.yy.yylivekit.audience.streamline.IHandler;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbsHandler
implements IHandler {
    private static final String TAG = "AbsHandler";

    protected boolean checkAccept(Set<LiveInfo> liveInfoSet, AcceptOption acceptOption) {
        for (LiveInfo info : liveInfoSet) {
            if (acceptOption.accept(info)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void fetchAllVideoLine(Set<LiveInfo> liveInfoSet) {
        if (!this.checkAccept(liveInfoSet, new AcceptOption(){

            @Override
            public boolean accept(LiveInfo info) {
                return info.isMix;
            }
        })) {
            YLKLog.e(TAG, " fetchAllVideoLine forbidden !");
            return;
        }
        StringBuffer sb = new StringBuffer("fetchAllVideoLine:");
        HashMap var = new HashMap();
        for (LiveInfo liveInfo : liveInfoSet) {
            if (!liveInfo.hasVideo()) continue;
            Set<Map.Entry<VideoGearInfo, StreamInfo>> entrySet = liveInfo.streamsForCurrentProperties().entrySet();
            for (Map.Entry<VideoGearInfo, StreamInfo> entry : entrySet) {
                StreamInfo streamInfo = entry.getValue();
                if (streamInfo == null || streamInfo.video == null) continue;
                sb.append("[").append(streamInfo.video.streamName).append("]\n");
                ArrayList<MediaInvoke.LiveStreamInfo> lineList = (ArrayList<MediaInvoke.LiveStreamInfo>)var.get(streamInfo.video.appId);
                if (FP.empty((Collection)lineList)) {
                    lineList = new ArrayList<MediaInvoke.LiveStreamInfo>();
                }
                HashMap<Integer, Integer> addCfg = new HashMap<Integer, Integer>();
                addCfg.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_LINE_GROUP, lineList.size());
                lineList.add(streamInfo.video.liveStreamInfo(addCfg));
                var.put(streamInfo.video.appId, lineList);
            }
        }
        YLKLog.i(TAG, "fetchAllVideoLine() allVideoName:" + sb);
        YLKLog.i(TAG, "fetchAllVideoLine() liveGetStreamLineInfo:" + var);
        IMediaVideoSDK.instance().getMedia().liveGetStreamLineInfo(var);
    }

    protected boolean isVideoLineInterrupt(VideoInfo videoInfo, MediaVideoMsg.LiveStreamLineInfo liveStreamLineInfo) {
        MediaVideoMsg.StreamLineInfo wannerStreamLineInfo = null;
        for (Map.Entry entry : liveStreamLineInfo.appIdToLineMap.entrySet()) {
            List streamLineInfos = (List)entry.getValue();
            if (FP.empty((Collection)streamLineInfos)) continue;
            for (MediaVideoMsg.StreamLineInfo streamLineInfo : streamLineInfos) {
                if (!streamLineInfo.streamName.equals(videoInfo.streamName)) continue;
                wannerStreamLineInfo = streamLineInfo;
                break;
            }
            if (wannerStreamLineInfo == null) continue;
            break;
        }
        return wannerStreamLineInfo == null || wannerStreamLineInfo != null && FP.empty((Collection)wannerStreamLineInfo.lines);
    }

    protected Map<Integer, List<VideoGearInfo>> parseLSLInfo(LiveInfo liveInfo, MediaVideoMsg.LiveStreamLineInfo liveStreamLineInfo) {
        HashMap<VideoGearInfo, List<Integer>> qulityLines = new HashMap<VideoGearInfo, List<Integer>>();
        YLKLog.i(TAG, "parseLSLInfo() liveStreamLineInfo.appIdToLineMap.size = [" + FP.size((Map)liveStreamLineInfo.appIdToLineMap) + "]");
        for (Map.Entry entry : liveStreamLineInfo.appIdToLineMap.entrySet()) {
            List streamLineInfos = (List)entry.getValue();
            for (MediaVideoMsg.StreamLineInfo streamLineInfo : streamLineInfos) {
                StreamInfo streamInfo = this.findStreamInfoByName(liveInfo, streamLineInfo.streamName);
                if (streamInfo != null) {
                    qulityLines.put(streamInfo.video.videoGearInfo, streamLineInfo.lines);
                    continue;
                }
                YLKLog.e(TAG, "parseLSLInfo() can not found streamName:" + streamLineInfo.streamName + ", liveInfo:" + liveInfo);
            }
        }
        YLKLog.i(TAG, "parseLSLInfo() qulityLines = [" + qulityLines + "]");
        return this.kvTrans(qulityLines);
    }

    private Map<Integer, List<VideoGearInfo>> kvTrans(Map<VideoGearInfo, List<Integer>> qulityLines) {
        HashMap<Integer, List<VideoGearInfo>> lineQuality = new HashMap<Integer, List<VideoGearInfo>>();
        for (Map.Entry<VideoGearInfo, List<Integer>> entry : qulityLines.entrySet()) {
            VideoGearInfo videoQuality = entry.getKey();
            for (Integer lineNo : entry.getValue()) {
                ArrayList<VideoGearInfo> qualities = (ArrayList<VideoGearInfo>)lineQuality.get(lineNo);
                if (FP.empty((Collection)qualities)) {
                    qualities = new ArrayList<VideoGearInfo>();
                }
                qualities.add(videoQuality);
                lineQuality.put(lineNo, qualities);
            }
        }
        YLKLog.i(TAG, "kvTrans() called with: qulityLines = [" + qulityLines + "]");
        return lineQuality;
    }

    private StreamInfo findStreamInfoByName(LiveInfo liveInfo, String streamName) {
        if (liveInfo == null || FP.empty(liveInfo.streamInfoList)) {
            YLKLog.i(TAG, "findStreamInfoByName() called with: liveInfo = [" + liveInfo + "], streamName = [" + streamName + "]");
            return null;
        }
        for (StreamInfo streamInfo : liveInfo.streamInfoList) {
            if (streamInfo.video == null || !FP.eq((Object)streamInfo.video.streamName, (Object)streamName)) continue;
            return streamInfo;
        }
        return null;
    }

    static interface AcceptOption {
        public boolean accept(LiveInfo var1);
    }
}

